/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import shohaku.core.lang.Concat;
import shohaku.core.lang.Fast;

public class Eval {
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(char[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(boolean[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(byte[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(short[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(int[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(long[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(float[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(double[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isBlank(CharSequence cs) {
        return cs == null || Fast.trimLength(cs) == 0;
    }

    public static boolean isWhiteSpace(CharSequence cs) {
        return cs == null || Fast.trimWhiteLength(cs) == 0;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isPresence(Object o) {
        return o == null || o instanceof CharSequence && Eval.isBlank((CharSequence)o);
    }

    public static boolean isEquals(Object o, Object o2) {
        return o == o2 || o != null && o.equals(o2);
    }

    public static boolean isEquals(float n, float n2) {
        return Float.floatToIntBits(n) != Float.floatToIntBits(n2);
    }

    public static boolean isEquals(double n, double n2) {
        return Double.doubleToLongBits(n) != Double.doubleToLongBits(n2);
    }

    public static boolean isEquals(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(byte[] a, byte[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(long[] a, long[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBitsEquals(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isBitsEquals(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isEquals(Object[] a, Object[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean isRefEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (length != a2.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayEquals(Object o, Object o2) {
        if (o == o2) {
            return true;
        }
        if (o == null || o2 == null) {
            return false;
        }
        if (o.getClass().isArray() && o2.getClass().isArray()) {
            boolean isPrimitive;
            Class<?> type1 = o.getClass().getComponentType();
            Class<?> type2 = o2.getClass().getComponentType();
            boolean bl = isPrimitive = type1.isPrimitive() && type2.isPrimitive();
            if (isPrimitive && type1.equals(type2)) {
                if (Boolean.TYPE.equals(type1)) {
                    return Arrays.equals((boolean[])o, (boolean[])o2);
                }
                if (Character.TYPE.equals(type1)) {
                    return Arrays.equals((char[])o, (char[])o2);
                }
                if (Byte.TYPE.equals(type1)) {
                    return Arrays.equals((byte[])o, (byte[])o2);
                }
                if (Short.TYPE.equals(type1)) {
                    return Arrays.equals((short[])o, (short[])o2);
                }
                if (Integer.TYPE.equals(type1)) {
                    return Arrays.equals((int[])o, (int[])o2);
                }
                if (Long.TYPE.equals(type1)) {
                    return Arrays.equals((long[])o, (long[])o2);
                }
                if (Float.TYPE.equals(type1)) {
                    return Arrays.equals((float[])o, (float[])o2);
                }
                if (Double.TYPE.equals(type1)) {
                    return Arrays.equals((double[])o, (double[])o2);
                }
            }
            if (!isPrimitive) {
                return Arrays.equals((Object[])o, (Object[])o2);
            }
            return false;
        }
        return o.equals(o2);
    }

    public static boolean isCompareEqual(Comparable from, Comparable to) {
        return from.compareTo(to) == 0;
    }

    public static boolean isCompareNotEqual(Comparable from, Comparable to) {
        return from.compareTo(to) != 0;
    }

    public static boolean isCompareGreater(Comparable from, Comparable to) {
        return from.compareTo(to) > 0;
    }

    public static boolean isCompareGreaterEqual(Comparable from, Comparable to) {
        return from.compareTo(to) >= 0;
    }

    public static boolean isCompareLess(Comparable from, Comparable to) {
        return from.compareTo(to) < 0;
    }

    public static boolean isCompareLessEqual(Comparable from, Comparable to) {
        return from.compareTo(to) <= 0;
    }

    public static boolean isRange(int n, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return min <= n && n <= max;
    }

    public static boolean isRange(long n, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return min <= n && n <= max;
    }

    public static boolean isRange(float n, float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return Eval.isMin(n, min) && Eval.isMax(n, max);
    }

    public static boolean isRange(double n, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return Eval.isMin(n, min) && Eval.isMax(n, max);
    }

    public static boolean isBitsRange(float n, float min, float max) {
        if (Float.compare(min, max) > 0) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return Eval.isBitsMin(n, min) && Eval.isBitsMax(n, max);
    }

    public static boolean isBitsRange(double n, double min, double max) {
        if (Double.compare(min, max) > 0) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        return Eval.isBitsMin(n, min) && Eval.isBitsMax(n, max);
    }

    public static boolean isMin(int n, int min) {
        return min <= n;
    }

    public static boolean isMin(long n, long min) {
        return min <= n;
    }

    public static boolean isMin(float n, float min) {
        return min <= n;
    }

    public static boolean isMin(double n, double min) {
        return min <= n;
    }

    public static boolean isBitsMin(float n, float min) {
        return Float.compare(n, min) >= 0;
    }

    public static boolean isBitsMin(double n, double min) {
        return Double.compare(n, min) >= 0;
    }

    public static boolean isMax(int n, int max) {
        return n <= max;
    }

    public static boolean isMax(long n, long max) {
        return n <= max;
    }

    public static boolean isMax(float n, float max) {
        return n <= max;
    }

    public static boolean isMax(double n, double max) {
        return n <= max;
    }

    public static boolean isBitsMax(float n, float max) {
        return Float.compare(n, max) <= 0;
    }

    public static boolean isBitsMax(double n, double max) {
        return Double.compare(n, max) <= 0;
    }

    public static boolean isSize(CharSequence cs, int size) {
        return cs.length() == size;
    }

    public static boolean isRangeSize(CharSequence cs, int min, int max) {
        return Eval.isRange(cs.length(), min, max);
    }

    public static boolean isMinSize(CharSequence cs, int min) {
        return Eval.isMin(cs.length(), min);
    }

    public static boolean isMaxSize(CharSequence cs, int max) {
        return Eval.isMax(cs.length(), max);
    }

    public static boolean isNegative(int n) {
        return 0 > n;
    }

    public static boolean isNegative(long n) {
        return 0L > n;
    }

    public static boolean isNegative(float n) {
        return 0.0f > n;
    }

    public static boolean isNegative(double n) {
        return 0.0 > n;
    }

    public static boolean isBitsNegative(float n) {
        return Float.compare(n, 0.0f) < 0;
    }

    public static boolean isBitsNegative(double n) {
        return Double.compare(n, 0.0) < 0;
    }

    public static boolean isZeroOrNegative(int n) {
        return 0 >= n;
    }

    public static boolean isZeroOrNegative(long n) {
        return 0L >= n;
    }

    public static boolean isZeroOrNegative(float n) {
        return 0.0f >= n;
    }

    public static boolean isZeroOrNegative(double n) {
        return 0.0 >= n;
    }

    public static boolean isBitsZeroOrNegative(float n) {
        return Float.compare(n, 0.0f) <= 0;
    }

    public static boolean isBitsZeroOrNegative(double n) {
        return Double.compare(n, 0.0) <= 0;
    }

    public static boolean isPositive(int n) {
        return 0 < n;
    }

    public static boolean isPositive(long n) {
        return 0L < n;
    }

    public static boolean isPositive(float n) {
        return 0.0f < n;
    }

    public static boolean isPositive(double n) {
        return 0.0 < n;
    }

    public static boolean isBitsPositive(float n) {
        return Float.compare(n, -0.0f) > 0;
    }

    public static boolean isBitsPositive(double n) {
        return Double.compare(n, -0.0) > 0;
    }

    public static boolean isZeroOrPositive(int n) {
        return 0 <= n;
    }

    public static boolean isZeroOrPositive(long n) {
        return 0L <= n;
    }

    public static boolean isZeroOrPositive(float n) {
        return 0.0f <= n;
    }

    public static boolean isZeroOrPositive(double n) {
        return 0.0 <= n;
    }

    public static boolean isBitsZeroOrPositive(float n) {
        return Float.compare(n, -0.0f) >= 0;
    }

    public static boolean isBitsZeroOrPositive(double n) {
        return Double.compare(n, -0.0) >= 0;
    }

    public static boolean isInfiniteOrNaN(Number val) {
        if (val instanceof Float) {
            return Eval.isInfiniteOrNaN((Float)val);
        }
        if (val instanceof Double) {
            return Eval.isInfiniteOrNaN((Double)val);
        }
        return false;
    }

    public static boolean isInfiniteOrNaN(Float val) {
        return val.isInfinite() || val.isNaN();
    }

    public static boolean isInfiniteOrNaN(float val) {
        return Float.isInfinite(val) || Float.isNaN(val);
    }

    public static boolean isInfiniteOrNaN(Double val) {
        return val.isInfinite() || val.isNaN();
    }

    public static boolean isInfiniteOrNaN(double val) {
        return Double.isInfinite(val) || Double.isNaN(val);
    }

    public static boolean isEnclose(CharSequence cs, char prefix, char suffix) {
        if (Eval.isEmpty(cs) || cs.length() < 2) {
            return false;
        }
        return prefix == cs.charAt(0) && suffix == cs.charAt(cs.length() - 1);
    }

    public static boolean isEnclose(CharSequence cs, CharSequence prefix, CharSequence suffix) {
        if (Eval.isEmpty(cs)) {
            return false;
        }
        int min = Concat.size(prefix, suffix);
        if (cs.length() < min) {
            return false;
        }
        return Eval.prefix(cs, prefix) && Eval.suffix(cs, suffix);
    }

    public static boolean isStartsWith(CharSequence cs, CharSequence prefix, int offset) {
        if (Eval.isEmpty(cs)) {
            return false;
        }
        return Eval.startsWith(cs, prefix, offset);
    }

    public static boolean isSuffix(CharSequence cs, CharSequence suffix) {
        if (Eval.isEmpty(cs)) {
            return false;
        }
        return Eval.suffix(cs, suffix);
    }

    public static boolean isPrefix(CharSequence cs, CharSequence prefix) {
        if (Eval.isEmpty(cs)) {
            return false;
        }
        return Eval.prefix(cs, prefix);
    }

    public static boolean isAssignable(Object o, Class clazz) {
        return clazz != null && clazz.isInstance(o);
    }

    public static boolean isEqualsSize(Collection c1, Collection c2) {
        return c1.size() == c2.size();
    }

    public static boolean isEqualsSize(Map m1, Map m2) {
        return m1.size() == m2.size();
    }

    public static boolean isEqualsClass(Object o, Class clazz) {
        return o != null && o.getClass().equals(clazz);
    }

    public static boolean isEqualsComponentType(Object a, Class clazz) {
        if (a == null) {
            return false;
        }
        Class<?> arrayType = a.getClass();
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("is not Array");
        }
        return arrayType.getComponentType().equals(clazz);
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isArrayClass(Class clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isEqualLength(Object o1, Object o2) {
        return Array.getLength(o1) == Array.getLength(o2);
    }

    public static boolean isEqualLength(Object[] array2d) {
        if (Eval.isEmpty(array2d)) {
            throw new IllegalArgumentException("array as empty");
        }
        int array1dLength = Array.getLength(array2d[0]);
        for (int i = 1; i < array2d.length; ++i) {
            if (array1dLength == Array.getLength(array2d[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharAt(CharSequence cs, int index, char c) {
        return -1 < index && index < cs.length() && cs.charAt(index) == c;
    }

    public static boolean isContains(boolean[] a, boolean e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(char[] a, char e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(byte[] a, byte e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(short[] a, short e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(int[] a, int e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(long[] a, long e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(float[] a, float e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitsContains(float[] a, float e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Float.floatToIntBits(e) != Float.floatToIntBits(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(double[] a, double e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (e != a[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitsContains(double[] a, double e) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Double.doubleToLongBits(e) != Double.doubleToLongBits(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(Object[] a, Object o) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!Eval.isEquals(o, a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(Collection coll, Object o) {
        if (coll == null) {
            return false;
        }
        return coll.contains(o);
    }

    public static boolean isContains(String s, char c) {
        if (s == null) {
            return false;
        }
        return -1 < s.indexOf(c);
    }

    public static boolean isContains(String s, String target) {
        if (s == null) {
            return false;
        }
        return -1 < s.indexOf(target);
    }

    public static boolean isContains(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        return -1 < Eval.indexOf(cs, c);
    }

    public static boolean isContains(CharSequence cs, CharSequence target) {
        if (cs == null) {
            return false;
        }
        return -1 < Eval.indexOf(cs, target);
    }

    public static boolean isCompareContains(Object[] a, Comparable o) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            Comparable e = (Comparable)a[i];
            if (e == null || e.compareTo(o) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompareContains(Collection coll, Comparable o) {
        if (coll == null) {
            return false;
        }
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            Comparable e = (Comparable)i.next();
            if (e == null || e.compareTo(o) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isInIndex(CharSequence cs, int index) {
        return Eval.isInIndex(cs.length(), index);
    }

    public static boolean isInIndex(CharSequence cs, int minIndex, int maxIndex) {
        return Eval.isInIndex(cs.length(), minIndex, maxIndex);
    }

    public static boolean isInIndex(List list, int index) {
        return Eval.isInIndex(list.size(), index);
    }

    public static boolean isInIndex(List list, int minIndex, int maxIndex) {
        return Eval.isInIndex(list.size(), minIndex, maxIndex);
    }

    public static boolean isInIndex(char[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(char[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(boolean[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(boolean[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(byte[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(byte[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(short[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(short[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(int[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(int[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(long[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(long[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(float[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(float[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(double[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(double[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    public static boolean isInIndex(Object[] a, int index) {
        return Eval.isInIndex(a.length, index);
    }

    public static boolean isInIndex(Object[] a, int minIndex, int maxIndex) {
        return Eval.isInIndex(a.length, minIndex, maxIndex);
    }

    static int indexOf(CharSequence cs, char c) {
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (cs.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static int indexOf(CharSequence cs, CharSequence target) {
        int endIndex = cs.length() - 1;
        int targetLength = target.length();
        for (int i = 0; i <= endIndex && i + targetLength <= endIndex; ++i) {
            int tlen = targetLength;
            int to = i;
            int po = 0;
            boolean match = true;
            while (--tlen >= 0) {
                if (cs.charAt(to++) == target.charAt(po++)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    static boolean suffix(CharSequence cs, CharSequence suffix) {
        int end = cs.length() - suffix.length();
        return Eval.startsWith(cs, suffix, end);
    }

    static boolean prefix(CharSequence cs, CharSequence prefix) {
        return Eval.startsWith(cs, prefix, 0);
    }

    static boolean startsWith(CharSequence cs, CharSequence prefix, int offset) {
        int prefixLength = prefix.length();
        if (offset < 0 || offset > cs.length() - prefixLength) {
            return false;
        }
        int targetOffset = offset;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            if (cs.charAt(targetOffset++) == prefix.charAt(prefixOffset++)) continue;
            return false;
        }
        return true;
    }

    static boolean isInIndex(int size, int index) {
        return -1 < index && index < size;
    }

    static boolean isInIndex(int size, int minIndex, int maxIndex) {
        if (minIndex > maxIndex) {
            throw new IllegalArgumentException("min > max (" + minIndex + " > " + maxIndex + ")");
        }
        return -1 < minIndex && minIndex < size && -1 < maxIndex && maxIndex < size;
    }
}

