/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.helpers.HFmt;
import shohaku.core.lang.VariableInteger;

class LogHelper {
    static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    static final int REPETITION_LIMIT = 255;

    LogHelper() {
    }

    static String array(Object o) {
        if (null == o) {
            return "null";
        }
        if (o.getClass().isArray()) {
            return LogHelper.toArrayString(o, new VariableInteger());
        }
        return String.valueOf(o);
    }

    static String arrays(Object o) {
        if (null == o) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.append(o, buff, new VariableInteger());
        return buff.toString();
    }

    private static String toArrayString(Object a, VariableInteger count) {
        Class<?> type = a.getClass().getComponentType();
        if (type.isPrimitive()) {
            if (type == Character.TYPE) {
                return LogHelper.toString((char[])a, count);
            }
            if (type == Boolean.TYPE) {
                return LogHelper.toString((boolean[])a, count);
            }
            if (type == Byte.TYPE) {
                return LogHelper.toString((byte[])a, count);
            }
            if (type == Short.TYPE) {
                return LogHelper.toString((short[])a, count);
            }
            if (type == Integer.TYPE) {
                return LogHelper.toString((int[])a, count);
            }
            if (type == Long.TYPE) {
                return LogHelper.toString((long[])a, count);
            }
            if (type == Float.TYPE) {
                return LogHelper.toString((float[])a, count);
            }
            if (type == Double.TYPE) {
                return LogHelper.toString((double[])a, count);
            }
        }
        return LogHelper.toString((Object[])a, count);
    }

    private static String toString(long[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(int[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(short[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(char[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(byte[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(boolean[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(float[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(double[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        buff.append(a[0]);
        count.increment();
        for (int i = 1; i < a.length; ++i) {
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(',');
            buff.append(a[i]);
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toString(Object[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buff.append('[');
            } else {
                buff.append(',');
            }
            if (count.intValue() >= 255) {
                buff.append("...");
                break;
            }
            buff.append(String.valueOf(a[i]));
            count.increment();
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toDeepString(Object[] a, VariableInteger count) {
        if (a == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(a, buff);
        if (a.length == 0) {
            return buff.append("[]").toString();
        }
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buff.append('[');
            } else {
                buff.append(',');
            }
            if (LogHelper.append(a[i], buff, count)) break;
        }
        buff.append(']');
        return buff.toString();
    }

    private static String toDeepString(Map map, VariableInteger count) {
        if (map == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(map, buff);
        if (map.size() == 0) {
            return buff.append("{}").toString();
        }
        buff.append('{');
        Iterator i = map.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            if (key == map) {
                buff.append("(this Map)");
            } else if (LogHelper.append(key, buff, count)) break;
            buff.append('=');
            if (value == map) {
                buff.append("(this Map)");
            } else if (LogHelper.append(value, buff, count)) break;
            if (!(hasNext = i.hasNext())) continue;
            buff.append(',');
        }
        buff.append('}');
        return buff.toString();
    }

    private static String toDeepString(Collection coll, VariableInteger count) {
        if (coll == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        LogHelper.appendClass(coll, buff);
        if (coll.size() == 0) {
            return buff.append("[]").toString();
        }
        buff.append('[');
        Iterator i = coll.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object e = i.next();
            if (e == coll) {
                buff.append("(this Collection)");
            } else if (LogHelper.append(e, buff, count)) break;
            if (!(hasNext = i.hasNext())) continue;
            buff.append(',');
        }
        buff.append(']');
        return buff.toString();
    }

    private static boolean append(Object o, StringBuffer buff, VariableInteger count) {
        if (count.intValue() >= 255) {
            buff.append("...");
            return true;
        }
        count.increment();
        if (o == null) {
            buff.append("null");
            return false;
        }
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                buff.append(LogHelper.toDeepString((Object[])o, count));
            } else {
                buff.append(LogHelper.toArrayString(o, count));
            }
        } else if (o instanceof Map) {
            buff.append(LogHelper.toDeepString((Map)o, count));
        } else if (o instanceof Collection) {
            buff.append(LogHelper.toDeepString((Collection)o, count));
        } else if (o instanceof Timestamp) {
            buff.append(String.valueOf(o));
        } else if (o instanceof Time) {
            buff.append(String.valueOf(o));
        } else if (o instanceof Date) {
            buff.append(HFmt.formatDate(o, DATETIME_FORMAT));
        } else if (o instanceof Calendar) {
            buff.append(HFmt.formatDate(o, DATETIME_FORMAT));
        } else {
            buff.append(String.valueOf(o));
        }
        return false;
    }

    private static void appendClass(Object o, StringBuffer buff) {
        buff.append('<');
        buff.append(o.getClass().getName());
        buff.append('>');
    }
}

