/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import shohaku.core.helpers.HCnv;
import shohaku.core.helpers.HSeek;
import shohaku.core.lang.RangeInt;

public class HValid {
    public static boolean isCharsOnly(CharSequence cs, char[] chars) {
        if (cs == null) {
            return false;
        }
        return 0 > HSeek.orOtherIndexOf(cs, chars, 1);
    }

    public static boolean isCharsOnly(CharSequence cs, char[] chars, int fromIndex, int toIndex) {
        if (cs == null) {
            return false;
        }
        return 0 > HSeek.orOtherIndexOf(cs, toIndex, fromIndex, chars, 1);
    }

    public static boolean isCharsRange(CharSequence cs, RangeInt rangeChar) {
        if (cs == null) {
            return false;
        }
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            if (rangeChar.contain(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharsRange(CharSequence cs, RangeInt[] rangeChars) {
        if (cs == null) {
            return false;
        }
        int len = cs.length();
        boolean hit = false;
        for (int i = 0; i < len; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < rangeChars.length; ++j) {
                if (!rangeChars[j].contain(ch)) continue;
                hit = true;
                break;
            }
            if (!hit) {
                return false;
            }
            hit = false;
        }
        return true;
    }

    public static boolean isDateTime(CharSequence date, String pattern) {
        return HValid.isDateTime(date, Locale.getDefault(), pattern);
    }

    public static boolean isDateTime(CharSequence date, Locale locale, String pattern) {
        return HValid.isDateTime(date, new DateFormatSymbols(locale), pattern);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, String pattern) {
        return HValid.isDateTime(date, symbols, pattern, false);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, String pattern, boolean lenient) {
        return date == null ? false : null != HCnv.toDateTime(date, symbols, pattern, lenient);
    }

    public static boolean isDateTime(CharSequence date, Collection patterns) {
        return HValid.isDateTime(date, Locale.getDefault(), patterns);
    }

    public static boolean isDateTime(CharSequence date, Locale locale, Collection patterns) {
        return HValid.isDateTime(date, new DateFormatSymbols(locale), patterns);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, Collection patterns) {
        return HValid.isDateTime(date, symbols, patterns, false);
    }

    public static boolean isDateTime(CharSequence date, DateFormatSymbols symbols, Collection patterns, boolean lenient) {
        return date == null ? false : null != HCnv.toDateTime(date, symbols, patterns, lenient);
    }

    public static boolean isDecimal(CharSequence num, String pattern) {
        return HValid.isDecimal(num, Locale.getDefault(), pattern);
    }

    public static boolean isDecimal(CharSequence num, Locale locale, String pattern) {
        return HValid.isDecimal(num, new DecimalFormatSymbols(locale), pattern);
    }

    public static boolean isDecimal(CharSequence num, DecimalFormatSymbols symbols, String pattern) {
        return num == null ? false : null != HCnv.toDecimal(num, symbols, pattern);
    }

    public static boolean isDecimal(CharSequence num, Collection patterns) {
        return HValid.isDecimal(num, Locale.getDefault(), patterns);
    }

    public static boolean isDecimal(CharSequence num, Locale locale, Collection patterns) {
        return HValid.isDecimal(num, new DecimalFormatSymbols(locale), patterns);
    }

    public static boolean isDecimal(CharSequence num, DecimalFormatSymbols symbols, Collection patterns) {
        return num == null ? false : null != HCnv.toDecimal(num, symbols, patterns);
    }

    public static boolean isEncode(char c, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return HValid.isEncode(c, Charset.forName(charsetName));
    }

    public static boolean isEncode(char c, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(c);
    }

    public static boolean isEncode(CharSequence cs, String charsetName) throws UnsupportedCharsetException, IllegalCharsetNameException, UnsupportedOperationException {
        return HValid.isEncode(cs, Charset.forName(charsetName));
    }

    public static boolean isEncode(CharSequence cs, Charset charset) throws UnsupportedOperationException {
        CharsetEncoder cEncoder = charset.newEncoder();
        return cEncoder.canEncode(cs);
    }
}

