/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.Eval;
import shohaku.core.lang.RangeInt;

public class HSeek {
    public static Object notNull(Object e, Object e2) {
        return e != null ? e : e2;
    }

    public static Object notNull(Object e, Object e2, Object e3) {
        return e != null ? e : (e2 != null ? e2 : e3);
    }

    public static String notEmpty(String e, String e2) {
        return !Eval.isEmpty(e) ? e : e2;
    }

    public static String notEmpty(String e, String e2, String e3) {
        return !Eval.isEmpty(e) ? e : (!Eval.isEmpty(e2) ? e2 : e3);
    }

    public static String notBlank(String e, String e2) {
        return !Eval.isBlank(e) ? e : e2;
    }

    public static String notBlank(String e, String e2, String e3) {
        return !Eval.isBlank(e) ? e : (!Eval.isBlank(e2) ? e2 : e3);
    }

    public static int skip(CharSequence cs, RangeInt range, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length() && range.contain(cs.charAt(inx)); ++inx) {
        }
        return inx;
    }

    public static int skip(CharSequence cs, RangeInt[] ranges, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length(); ++inx) {
            char c = cs.charAt(inx);
            boolean hit = false;
            for (int i = 0; i < ranges.length; ++i) {
                if (!ranges[i].contain(c)) continue;
                hit = true;
                break;
            }
            if (!hit) break;
        }
        return inx;
    }

    public static int skip(CharSequence cs, char c, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length() && cs.charAt(inx) == c; ++inx) {
        }
        return inx;
    }

    public static int skipGreater(CharSequence cs, int c, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length() && cs.charAt(inx) > c; ++inx) {
        }
        return inx;
    }

    public static int skipLess(CharSequence cs, int c, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length() && cs.charAt(inx) < c; ++inx) {
        }
        return inx;
    }

    public static int skipSp(CharSequence cs, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length() && cs.charAt(inx) <= ' '; ++inx) {
        }
        return inx;
    }

    public static int skip(CharSequence cs, CharSequence chars, int fromIndex) {
        int inx;
        int charslen = chars.length();
        for (inx = fromIndex; inx < cs.length() && Eval.isStartsWith(cs, chars, inx); inx += charslen) {
        }
        return inx;
    }

    public static int skip(CharSequence cs, char[] chars, int fromIndex) {
        int inx;
        for (inx = fromIndex; inx < cs.length(); ++inx) {
            char c = cs.charAt(inx);
            boolean hit = false;
            for (int i = 0; i < chars.length; ++i) {
                if (c != chars[i]) continue;
                hit = true;
                break;
            }
            if (!hit) break;
        }
        return inx;
    }

    public static int count(Collection c, Object o) {
        if (c instanceof Set) {
            return c.contains(o) ? 1 : 0;
        }
        int count = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!Eval.isEquals(i.next(), o)) continue;
            ++count;
        }
        return count;
    }

    public static int indexOf(CharSequence cs, char searchChar, int count) {
        return HSeek.indexOf(cs, 0, cs.length() - 1, searchChar, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, char searchChar, int count) {
        return HSeek.indexOf(cs, fromIndex, cs.length() - 1, searchChar, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, int toIndex, char searchChar, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(cs, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (cs.charAt(i) != searchChar || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (cs.charAt(i) != searchChar || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int orIndexOf(CharSequence cs, char[] searchChars, int count) {
        return HSeek.orIndexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int orIndexOf(CharSequence cs, int fromIndex, char[] searchChars, int count) {
        return HSeek.orIndexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int orIndexOf(CharSequence cs, int fromIndex, int toIndex, char[] searchChars, int count) {
        block6: {
            int limit;
            int _count;
            block5: {
                if (!Eval.isInIndex(cs, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block5;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    char c = cs.charAt(i);
                    for (int j = 0; j < searchChars.length; ++j) {
                        if (c != searchChars[j] || ++_count != limit) continue;
                        return i;
                    }
                }
                break block6;
            }
            if (0 <= count) break block6;
            for (int i = toIndex; i >= fromIndex; --i) {
                char c = cs.charAt(i);
                for (int j = 0; j < searchChars.length; ++j) {
                    if (c != searchChars[j] || ++_count != limit) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int orOtherIndexOf(CharSequence cs, char[] searchChars, int count) {
        return HSeek.orOtherIndexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int orOtherIndexOf(CharSequence cs, int fromIndex, char[] searchChars, int count) {
        return HSeek.orOtherIndexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int orOtherIndexOf(CharSequence cs, int fromIndex, int toIndex, char[] searchChars, int count) {
        block8: {
            int limit;
            int _count;
            block7: {
                if (!Eval.isInIndex(cs, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block7;
                boolean hit = false;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    char c = cs.charAt(i);
                    for (int j = 0; j < searchChars.length; ++j) {
                        if (c != searchChars[j]) continue;
                        hit = true;
                        break;
                    }
                    if (!hit && ++_count == limit) {
                        return i;
                    }
                    hit = false;
                }
                break block8;
            }
            if (0 <= count) break block8;
            boolean hit = false;
            for (int i = toIndex; i >= fromIndex; --i) {
                char c = cs.charAt(i);
                for (int j = 0; j < searchChars.length; ++j) {
                    if (c != searchChars[j]) continue;
                    hit = true;
                    break;
                }
                if (!hit && ++_count == limit) {
                    return i;
                }
                hit = false;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChars, int count) {
        return HSeek.indexOf(cs, 0, cs.length() - 1, searchChars, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, CharSequence searchChars, int count) {
        return HSeek.indexOf(cs, fromIndex, cs.length() - 1, searchChars, count);
    }

    public static int indexOf(CharSequence cs, int fromIndex, int toIndex, CharSequence searchChars, int count) {
        block7: {
            int plen;
            int limit;
            int _count;
            block6: {
                int plen2;
                if (!Eval.isInIndex(cs, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", cs.length(), fromIndex, toIndex));
                }
                if (searchChars.length() == 0) {
                    return -1;
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block6;
                for (int i = fromIndex; i <= toIndex && i + (plen2 = searchChars.length()) <= toIndex; ++i) {
                    int to = i;
                    int po = 0;
                    boolean match = true;
                    while (--plen2 >= 0) {
                        if (cs.charAt(to++) == searchChars.charAt(po++)) continue;
                        match = false;
                        break;
                    }
                    if (!match || ++_count != limit) continue;
                    return i;
                }
                break block7;
            }
            if (0 <= count) break block7;
            for (int i = toIndex; i >= fromIndex && i - (plen = searchChars.length()) >= fromIndex; --i) {
                int to = i - plen;
                int po = 0;
                boolean match = true;
                while (--plen >= 0) {
                    if (cs.charAt(to++) == searchChars.charAt(po++)) continue;
                    match = false;
                    break;
                }
                if (!match || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(List list, int fromIndex, int toIndex, Object search, int count) {
        block10: {
            int limit;
            int _count;
            block9: {
                if (!Eval.isInIndex(list, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", list.size(), fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block9;
                if (search == null) {
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        if (list.get(i) != null || ++_count != limit) continue;
                        return i;
                    }
                } else {
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        if (!search.equals(list.get(i)) || ++_count != limit) continue;
                        return i;
                    }
                }
                break block10;
            }
            if (0 <= count) break block10;
            if (search == null) {
                for (int i = toIndex; i >= fromIndex; --i) {
                    if (list.get(i) != null || ++_count != limit) continue;
                    return i;
                }
            } else {
                for (int i = toIndex; i >= fromIndex; --i) {
                    if (!search.equals(list.get(i)) || ++_count != limit) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int indexOf(Object[] a, int fromIndex, int toIndex, Object search, int count) {
        block10: {
            int limit;
            int _count;
            block9: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block9;
                if (search == null) {
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        if (a[i] != null || ++_count != limit) continue;
                        return i;
                    }
                } else {
                    for (int i = fromIndex; i <= toIndex; ++i) {
                        if (!search.equals(a[i]) || ++_count != limit) continue;
                        return i;
                    }
                }
                break block10;
            }
            if (0 <= count) break block10;
            if (search == null) {
                for (int i = toIndex; i >= fromIndex; --i) {
                    if (a[i] != null || ++_count != limit) continue;
                    return i;
                }
            } else {
                for (int i = toIndex; i >= fromIndex; --i) {
                    if (!search.equals(a[i]) || ++_count != limit) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int indexOf(boolean[] a, int fromIndex, int toIndex, boolean search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] a, int fromIndex, int toIndex, char search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(byte[] a, int fromIndex, int toIndex, byte search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(short[] a, int fromIndex, int toIndex, short search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] a, int fromIndex, int toIndex, int search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] a, int fromIndex, int toIndex, long search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(float[] a, int fromIndex, int toIndex, float search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(double[] a, int fromIndex, int toIndex, double search, int count) {
        block4: {
            int limit;
            int _count;
            block3: {
                if (!Eval.isInIndex(a, fromIndex, toIndex)) {
                    throw new IllegalArgumentException(HLog.range("index err. ", a.length, fromIndex, toIndex));
                }
                _count = 0;
                limit = Math.abs(count);
                if (0 >= count) break block3;
                for (int i = fromIndex; i <= toIndex; ++i) {
                    if (search != a[i] || ++_count != limit) continue;
                    return i;
                }
                break block4;
            }
            if (0 <= count) break block4;
            for (int i = toIndex; i >= fromIndex; --i) {
                if (search != a[i] || ++_count != limit) continue;
                return i;
            }
        }
        return -1;
    }
}

