/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import shohaku.core.helpers.HCnv;
import shohaku.core.lang.EvalSet;

public class HFmt {
    public static String formatDecimal(Number number, String pattern) {
        return HFmt.formatDecimal(number, Locale.getDefault(), pattern);
    }

    public static String formatDecimal(Number number, Locale locale, String pattern) {
        return HFmt.formatDecimal(number, new DecimalFormatSymbols(locale), pattern);
    }

    public static String formatDecimal(Number number, DecimalFormatSymbols symbols, String pattern) {
        DecimalFormat formatter = new DecimalFormat(pattern, symbols);
        return formatter.format(number);
    }

    public static String formatDate(Object date, String pattern) {
        return HFmt.formatDate(date, Locale.getDefault(), pattern);
    }

    public static String formatDate(Object date, Locale locale, String pattern) {
        return HFmt.formatDate(date, new DateFormatSymbols(locale), pattern);
    }

    public static String formatDate(Object date, DateFormatSymbols symbols, String pattern) {
        if (!EvalSet.isOrAssignable(date, Date.class, Calendar.class, Number.class)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, symbols);
        return formatter.format(HCnv.asDataObject(date));
    }

    public static String formatDate(Object date, int style, Locale locale) {
        if (!EvalSet.isOrAssignable(date, Date.class, Calendar.class, Number.class)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        DateFormat formatter = DateFormat.getDateInstance(style, locale);
        return formatter.format(HCnv.asDataObject(date));
    }

    public static String formatDateTime(Object date, int dateStyle, int timeStyle, Locale locale) {
        if (!EvalSet.isOrAssignable(date, Date.class, Calendar.class, Number.class)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        DateFormat formatter = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        return formatter.format(HCnv.asDataObject(date));
    }

    public static String formatTime(Object date, int style, Locale locale) {
        if (!EvalSet.isOrAssignable(date, Date.class, Calendar.class, Number.class)) {
            throw new IllegalArgumentException("argument o is not Date or Calendar :" + date);
        }
        DateFormat formatter = DateFormat.getTimeInstance(style, locale);
        return formatter.format(HCnv.asDataObject(date));
    }
}

