/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import shohaku.core.helpers.HSeek;
import shohaku.core.lang.Eval;

public class HCut {
    public static char begin(CharSequence cs) {
        return cs.charAt(0);
    }

    public static char end(CharSequence cs) {
        return cs.charAt(cs.length() - 1);
    }

    public static CharSequence trim(CharSequence cs, int direction) {
        int st;
        int len = cs.length();
        if (0 <= direction) {
            for (st = 0; st < len && cs.charAt(st) <= ' '; ++st) {
            }
        }
        if (0 >= direction) {
            while (st < len && cs.charAt(len - 1) <= ' ') {
                --len;
            }
        }
        if (cs instanceof String) {
            return st > 0 || len < cs.length() ? cs.subSequence(st, len) : cs;
        }
        return cs.subSequence(st, len);
    }

    public static CharSequence trimWhite(CharSequence cs, int direction) {
        int st;
        int len = cs.length();
        if (0 <= direction) {
            for (st = 0; st < len && Character.isWhitespace(cs.charAt(st)); ++st) {
            }
        }
        if (0 >= direction) {
            while (st < len && Character.isWhitespace(cs.charAt(len - 1))) {
                --len;
            }
        }
        if (cs instanceof String) {
            return st > 0 || len < cs.length() ? cs.subSequence(st, len) : cs;
        }
        return cs.subSequence(st, len);
    }

    public static CharSequence trim(CharSequence cs, char chars, int direction) {
        int st;
        int len = cs.length();
        if (0 <= direction) {
            for (st = 0; st < len && chars == cs.charAt(st); ++st) {
            }
        }
        if (0 >= direction) {
            while (st < len && chars == cs.charAt(len - 1)) {
                --len;
            }
        }
        if (cs instanceof String) {
            return st > 0 || len < cs.length() ? cs.subSequence(st, len) : cs;
        }
        return cs.subSequence(st, len);
    }

    public static CharSequence trim(CharSequence cs, char[] chars, int direction) {
        int st;
        int len = cs.length();
        if (0 <= direction) {
            for (st = 0; st < len && Eval.isContains(chars, cs.charAt(st)); ++st) {
            }
        }
        if (0 >= direction) {
            while (st < len && Eval.isContains(chars, cs.charAt(len - 1))) {
                --len;
            }
        }
        if (cs instanceof String) {
            return st > 0 || len < cs.length() ? cs.subSequence(st, len) : cs;
        }
        return cs.subSequence(st, len);
    }

    public static CharSequence cut(CharSequence cs, int beginSize, int endSize) {
        return cs.subSequence(beginSize, cs.length() - endSize);
    }

    public static CharSequence cutIndexOf(CharSequence cs, int beginSize, char endChar) {
        int endSize = HSeek.indexOf(cs, beginSize, endChar, 1);
        endSize = -1 < endSize ? endSize : cs.length();
        return cs.subSequence(beginSize, endSize);
    }

    public static CharSequence cutIndexOf(CharSequence cs, char beginChar, int endSize) {
        int beginSize = HSeek.indexOf(cs, 0, cs.length() - 1 - endSize, beginChar, 1);
        beginSize = -1 < beginSize ? beginSize : 0;
        return cs.subSequence(beginSize, cs.length() - endSize);
    }

    public static CharSequence cutLastIndexOf(CharSequence cs, char beginChar, int endSize) {
        int beginSize = HSeek.indexOf(cs, 0, cs.length() - 1 - endSize, beginChar, -1);
        beginSize = -1 < beginSize ? beginSize + 1 : 0;
        return cs.subSequence(beginSize, cs.length() - endSize);
    }
}

