/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import shohaku.core.lang.Eval;
import shohaku.core.lang.RangeInt;

public class HCnv {
    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static Number toDecimal(CharSequence num, String pattern) {
        return HCnv.toDecimal(num, Locale.getDefault(), pattern);
    }

    public static Number toDecimal(CharSequence num, Locale locale, String pattern) {
        return HCnv.toDecimal(num, new DecimalFormatSymbols(locale), pattern);
    }

    public static Number toDecimal(CharSequence num, DecimalFormatSymbols symbols, String pattern) {
        return HCnv.toDecimal(num, symbols, new ParsePosition(0), pattern);
    }

    public static Number toDecimal(CharSequence num, DecimalFormatSymbols symbols, ParsePosition pos, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        return HCnv.parseNumber(num, pos, format);
    }

    public static Number toDecimal(CharSequence num, DecimalFormatSymbols symbols, Collection patterns) {
        return HCnv.toDecimal(num, symbols, 0, patterns);
    }

    public static Number toDecimal(CharSequence num, DecimalFormatSymbols symbols, int posIndex, Collection patterns) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(symbols);
        Iterator i = patterns.iterator();
        while (i.hasNext()) {
            String pattern = (String)i.next();
            ParsePosition pos = new ParsePosition(posIndex);
            format.applyPattern(pattern);
            Number n = HCnv.parseNumber(num, pos, format);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    public static Number toDecimal(CharSequence num, int roundingMode, int maxScale, String pattern) {
        return HCnv.toDecimal(num, new DecimalFormatSymbols(), new ParsePosition(0), roundingMode, new RangeInt(0, maxScale), pattern);
    }

    public static Number toDecimal(CharSequence num, DecimalFormatSymbols symbols, ParsePosition pos, int roundingMode, RangeInt scale, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, symbols);
        format.setMinimumFractionDigits(scale.getMin());
        format.setMaximumFractionDigits(scale.getMax() + 1);
        Number n = HCnv.parseNumber(num, pos, format);
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).setScale(scale.getMax(), roundingMode);
        }
        return n;
    }

    static Number parseNumber(CharSequence num, ParsePosition pos, NumberFormat format) {
        Number n = format.parse(((Object)num).toString(), pos);
        if (pos.getErrorIndex() == -1) {
            return null;
        }
        return Eval.isInfiniteOrNaN(n) ? n : new BigDecimal(n.toString());
    }

    public static Date asDataObject(Object src) {
        if (src instanceof Date) {
            return (Date)src;
        }
        if (src instanceof Calendar) {
            return ((Calendar)src).getTime();
        }
        if (src instanceof Number) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(((Number)src).longValue());
            return calendar.getTime();
        }
        throw new IllegalArgumentException("is not Date Type. src=" + src);
    }

    public static Date toDateTime(CharSequence date, String pattern) {
        return HCnv.toDateTime(date, Locale.getDefault(), pattern);
    }

    public static Date toDateTime(CharSequence date, Locale locale, String pattern) {
        return HCnv.toDateTime(date, new DateFormatSymbols(locale), pattern);
    }

    public static Date toDateTime(CharSequence date, DateFormatSymbols symbols, String pattern) {
        return HCnv.toDateTime(date, symbols, pattern, false);
    }

    public static Date toDateTime(CharSequence date, DateFormatSymbols symbols, String pattern, boolean lenient) {
        return HCnv.toDateTime(date, symbols, new ParsePosition(0), pattern, lenient);
    }

    public static Date toDateTime(CharSequence date, DateFormatSymbols symbols, ParsePosition pos, String pattern, boolean lenient) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, symbols);
        format.setLenient(lenient);
        Date d = ((DateFormat)format).parse(((Object)date).toString(), pos);
        if (pos.getErrorIndex() != -1) {
            return null;
        }
        return d;
    }

    public static Date toDateTime(CharSequence date, Collection patterns) {
        return HCnv.toDateTime(date, Locale.getDefault(), patterns);
    }

    public static Date toDateTime(CharSequence date, Locale locale, Collection patterns) {
        return HCnv.toDateTime(date, new DateFormatSymbols(locale), patterns, false);
    }

    public static Date toDateTime(CharSequence date, DateFormatSymbols symbols, Collection patterns, boolean lenient) {
        return HCnv.toDateTime(date, symbols, 0, patterns, lenient);
    }

    public static Date toDateTime(CharSequence date, DateFormatSymbols symbols, int posIndex, Collection patterns, boolean lenient) {
        SimpleDateFormat format = new SimpleDateFormat();
        format.setDateFormatSymbols(symbols);
        format.setLenient(lenient);
        String sdate = ((Object)date).toString();
        Iterator i = patterns.iterator();
        while (i.hasNext()) {
            String pattern = (String)i.next();
            ParsePosition pos = new ParsePosition(posIndex);
            format.applyPattern(pattern);
            Date d = format.parse(sdate, pos);
            if (pos.getErrorIndex() != -1) continue;
            return d;
        }
        return null;
    }
}

