/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import shohaku.core.helpers.HCut;
import shohaku.core.lang.Boxing;
import shohaku.core.lang.Closure;
import shohaku.core.lang.Concat;
import shohaku.core.lang.Eval;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.feature.FeatureFactory;

public class HClass {
    static final char OBJECT_SYMBOL = 'L';
    static final Map PRIMITIVE_FOR_TYPE_MAP;
    static final Map PRIMITIVE_CLASS_NAME_MAP;

    public static Class getSourceComponentType(Class clazz) {
        if (clazz.isArray()) {
            return HClass.getSourceComponentType(clazz.getComponentType());
        }
        return clazz;
    }

    public static int getArraysDimensionSize(Class clazz) {
        int size = 0;
        Class<?> srcClass = clazz;
        while (srcClass.isArray()) {
            ++size;
            srcClass = srcClass.getComponentType();
        }
        return size;
    }

    public static String getShortClassName(Class clazz) {
        return (String)HCut.cutLastIndexOf(clazz.getName(), '.', 0);
    }

    public static String getSourceClassName(Class clazz) {
        StringBuffer arraySymbol = new StringBuffer();
        Class<?> srcClass = clazz;
        while (srcClass.isArray()) {
            arraySymbol.append("[]");
            srcClass = srcClass.getComponentType();
        }
        return Concat.get((Object)srcClass.getName(), arraySymbol);
    }

    public static Class box(Class clazz) {
        if (clazz.isPrimitive()) {
            return Boxing.boxClass(clazz);
        }
        return clazz;
    }

    public static boolean boxEquals(Class type, Class type2) {
        Class t2;
        Class t = type;
        if (t.isPrimitive()) {
            t = Boxing.boxClass(t);
        }
        if ((t2 = type2).isPrimitive()) {
            t2 = Boxing.boxClass(t2);
        }
        return t.equals(t2);
    }

    public static Class load(String name, ClassLoader loader, Closure finder) throws NoSuchResourceException {
        int off;
        StringBuffer symbol = new StringBuffer(4);
        for (off = name.length(); off >= 2 && name.charAt(off - 1) == ']' && name.charAt(off - 2) == '['; off -= 2) {
            symbol.append('[');
        }
        boolean isArray = symbol.length() > 0;
        String rootName = isArray ? name.substring(0, off) : name;
        Class clazz = HClass.findByClassName(rootName, finder);
        if (isArray) {
            StringBuffer className = new StringBuffer();
            if (clazz != null) {
                String primitiveName = (String)PRIMITIVE_CLASS_NAME_MAP.get(clazz);
                if (primitiveName == null) {
                    className.append(symbol).append('L').append(clazz.getName()).append(';');
                } else {
                    className.append(symbol).append(primitiveName);
                }
            } else {
                className.append(symbol).append('L').append(rootName).append(';');
            }
            return FeatureFactory.getLoader().getClass(className.toString(), loader);
        }
        if (clazz != null) {
            return clazz;
        }
        return FeatureFactory.getLoader().getClass(rootName, loader);
    }

    static Class findByClassName(String className, Closure finder) {
        Class<?> clazz = (Class<?>)PRIMITIVE_FOR_TYPE_MAP.get(className);
        if (clazz == null && !Eval.isContains(className, '.')) {
            try {
                clazz = Class.forName(Concat.get("java.lang.", className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && finder != null) {
            clazz = (Class)finder.evaluate(className);
        }
        return clazz;
    }

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(Byte.TYPE.getName(), Byte.TYPE);
        m.put(Short.TYPE.getName(), Short.TYPE);
        m.put(Integer.TYPE.getName(), Integer.TYPE);
        m.put(Long.TYPE.getName(), Long.TYPE);
        m.put(Float.TYPE.getName(), Float.TYPE);
        m.put(Double.TYPE.getName(), Double.TYPE);
        m.put(Boolean.TYPE.getName(), Boolean.TYPE);
        m.put(Character.TYPE.getName(), Character.TYPE);
        m.put(Void.TYPE.getName(), Void.TYPE);
        PRIMITIVE_FOR_TYPE_MAP = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Byte.TYPE, "B");
        m.put(Short.TYPE, "S");
        m.put(Integer.TYPE, "I");
        m.put(Long.TYPE, "J");
        m.put(Float.TYPE, "F");
        m.put(Double.TYPE, "D");
        m.put(Boolean.TYPE, "Z");
        m.put(Character.TYPE, "C");
        m.put(Void.TYPE, "V");
        PRIMITIVE_CLASS_NAME_MAP = Collections.unmodifiableMap(m);
    }
}

