/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import shohaku.core.helpers.HBeans;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.lang.feature.LogFeature;

class BeanIntrospectDescriptor {
    private static final LogFeature log = FeatureFactory.getLog(BeanIntrospectDescriptor.class);
    private static final Map classCache = new WeakHashMap();
    private final BeanInfo beanInfo;
    private Collection constructors;
    private Map propDesc;
    private Map methodGroup;
    private Map accessibleMethodGroup;
    private Map constants;
    private Map fieldGroup;
    private Map accessibleFieldGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BeanIntrospectDescriptor forClass(Class clazz) throws IntrospectionBeansException {
        if (clazz == null) {
            throw new NullPointerException("argument is null.");
        }
        Map map = classCache;
        synchronized (map) {
            BeanIntrospectDescriptor results = (BeanIntrospectDescriptor)classCache.get(clazz);
            if (results == null) {
                results = new BeanIntrospectDescriptor(clazz);
                classCache.put(clazz, results);
            }
            return results;
        }
    }

    private BeanIntrospectDescriptor(Class clazz) throws IntrospectionBeansException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("get BeanInfo." + clazz.getName());
            }
            this.beanInfo = Introspector.getBeanInfo(clazz);
            Class classToFlush = clazz;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
        }
        catch (SecurityException e) {
            throw new IntrospectionBeansException("Security error. " + clazz.getName(), e);
        }
        catch (IntrospectionException e) {
            throw new IntrospectionBeansException("Cannot get BeanInfo for object. " + clazz.getName(), e);
        }
    }

    private Collection constructors() {
        LinkedList conses = new LinkedList();
        try {
            Constructor<?>[] cs = this.getBeanClass().getConstructors();
            for (int i = 0; i < cs.length; ++i) {
                conses.add(cs[i]);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        return Collections.unmodifiableCollection(conses);
    }

    private Map methodGroup() {
        if (!Modifier.isPublic(this.getBeanClass().getModifiers())) {
            return Collections.EMPTY_MAP;
        }
        HashMap group = new HashMap();
        this.methodGroup0(group, this.getBeanClass());
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Collection coll = (Collection)e.getValue();
            e.setValue(Collections.unmodifiableCollection(coll));
        }
        return Collections.unmodifiableMap(group);
    }

    private void methodGroup0(Map group, Class clazz) {
        Class c;
        int i;
        try {
            Method[] ms = clazz.getDeclaredMethods();
            for (i = 0; i < ms.length; ++i) {
                LinkedList<Method> coll;
                Method m = ms[i];
                if (!Modifier.isPublic(m.getModifiers())) continue;
                if (!Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                    m.setAccessible(true);
                }
                if ((coll = (LinkedList<Method>)group.get(m.getName())) == null) {
                    coll = new LinkedList<Method>();
                    group.put(m.getName(), coll);
                }
                coll.add(m);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            this.methodGroup0(group, c2);
        }
        if (!clazz.isInterface() && (c = clazz.getSuperclass()) != null) {
            this.methodGroup0(group, c);
        }
    }

    private Map accessibleMethodGroup() {
        HashMap group = new HashMap();
        this.accessibleMethodGroup0(group, this.getBeanClass());
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Collection coll = (Collection)e.getValue();
            e.setValue(Collections.unmodifiableCollection(coll));
        }
        return Collections.unmodifiableMap(group);
    }

    private void accessibleMethodGroup0(Map group, Class clazz) {
        Class c;
        int i;
        try {
            Method[] ms = clazz.getDeclaredMethods();
            for (i = 0; i < ms.length; ++i) {
                LinkedList<Method> coll;
                Method m = ms[i];
                if (!Modifier.isPublic(m.getModifiers()) || !Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
                    m.setAccessible(true);
                }
                if ((coll = (LinkedList<Method>)group.get(m.getName())) == null) {
                    coll = new LinkedList<Method>();
                    group.put(m.getName(), coll);
                }
                coll.add(m);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            this.accessibleMethodGroup0(group, c2);
        }
        if (!clazz.isInterface() && (c = clazz.getSuperclass()) != null) {
            this.accessibleMethodGroup0(group, c);
        }
    }

    private Map fieldGroup() {
        if (!Modifier.isPublic(this.getBeanClass().getModifiers())) {
            return Collections.EMPTY_MAP;
        }
        HashMap group = new HashMap();
        this.fieldGroup0(group, this.getBeanClass());
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Collection coll = (Collection)e.getValue();
            e.setValue(Collections.unmodifiableCollection(coll));
        }
        return Collections.unmodifiableMap(group);
    }

    private void fieldGroup0(Map group, Class clazz) {
        Class c;
        int i;
        try {
            Field[] fs = clazz.getDeclaredFields();
            for (i = 0; i < fs.length; ++i) {
                LinkedList<Field> coll;
                Field f = fs[i];
                if (!Modifier.isPublic(f.getModifiers())) continue;
                if (!Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                    f.setAccessible(true);
                }
                if ((coll = (LinkedList<Field>)group.get(f.getName())) == null) {
                    coll = new LinkedList<Field>();
                    group.put(f.getName(), coll);
                }
                coll.add(f);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            this.fieldGroup0(group, c2);
        }
        if (!clazz.isInterface() && (c = clazz.getSuperclass()) != null) {
            this.fieldGroup0(group, c);
        }
    }

    private Map accessibleFieldGroup() {
        HashMap group = new HashMap();
        this.accessibleFieldGroup0(group, this.getBeanClass());
        Iterator i = group.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Collection coll = (Collection)e.getValue();
            e.setValue(Collections.unmodifiableCollection(coll));
        }
        return Collections.unmodifiableMap(group);
    }

    private void accessibleFieldGroup0(Map group, Class clazz) {
        Class c;
        int i;
        try {
            Field[] fs = clazz.getDeclaredFields();
            for (i = 0; i < fs.length; ++i) {
                LinkedList<Field> coll;
                Field f = fs[i];
                if (!Modifier.isPublic(f.getModifiers()) || !Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                    f.setAccessible(true);
                }
                if ((coll = (LinkedList<Field>)group.get(f.getName())) == null) {
                    coll = new LinkedList<Field>();
                    group.put(f.getName(), coll);
                }
                coll.add(f);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            this.accessibleFieldGroup0(group, c2);
        }
        if (!clazz.isInterface() && (c = clazz.getSuperclass()) != null) {
            this.accessibleFieldGroup0(group, c);
        }
    }

    private Map propDesc() {
        if (!Modifier.isPublic(this.getBeanClass().getModifiers())) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, PropertyDescriptor> pdsMap = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                Method readMethod = pd.getReadMethod();
                Method writeMethod = pd.getWriteMethod();
                if (readMethod != null && !Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if (writeMethod != null && !Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                pdsMap.put(pd.getName(), pd);
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        return Collections.unmodifiableMap(pdsMap);
    }

    private Map constants() {
        if (!Modifier.isPublic(this.getBeanClass().getModifiers())) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> fsMap = new HashMap<String, Object>();
        try {
            Class clazz = this.getBeanClass();
            Field[] fields = clazz.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                fsMap.put(field.getName(), field.get(null));
            }
        }
        catch (SecurityException e) {
            log.debug("Security error. " + this.getBeanClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            log.debug("field Introspection error. " + this.getBeanClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            log.debug("field Introspection error. " + this.getBeanClass().getName(), e);
        }
        return Collections.unmodifiableMap(fsMap);
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    Collection getConstructors() {
        Collection c = this.constructors;
        return c != null ? c : (this.constructors = this.constructors());
    }

    Constructor getConstructor(Class[] paramTypes) {
        if (paramTypes == null) {
            throw new NullPointerException("argument is null.");
        }
        Collection conses = this.getConstructors();
        Iterator i = conses.iterator();
        while (i.hasNext()) {
            Constructor cons = (Constructor)i.next();
            if (!Eval.isRefEquals(cons.getParameterTypes(), paramTypes)) continue;
            return cons;
        }
        return null;
    }

    Constructor getAssignmentConstructor(Class[] paramTypes) {
        if (paramTypes == null) {
            throw new NullPointerException("argument is null.");
        }
        Constructor cons = this.getConstructor(paramTypes);
        if (cons != null) {
            return cons;
        }
        Collection conses = this.getConstructors();
        Iterator i = conses.iterator();
        while (i.hasNext()) {
            cons = (Constructor)i.next();
            if (!HBeans.isAssignmentCompatible(cons.getParameterTypes(), paramTypes)) continue;
            return cons;
        }
        return null;
    }

    Map getConstantFieldMap() {
        Map m = this.constants;
        return m != null ? m : (this.constants = this.constants());
    }

    Object getConstantField(String fieldName) {
        return this.getConstantFieldMap().get(fieldName);
    }

    Map getPropertyDescriptorMap() {
        Map m = this.propDesc;
        return m != null ? m : (this.propDesc = this.propDesc());
    }

    Collection getPropertyDescriptors() {
        return this.getPropertyDescriptorMap().values();
    }

    PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.getPropertyDescriptorMap().get(propertyName);
    }

    Map getFieldGroup() {
        Map g = this.fieldGroup;
        return g != null ? g : (this.fieldGroup = this.fieldGroup());
    }

    Collection getFields(String fieldName) {
        return (Collection)this.getFieldGroup().get(fieldName);
    }

    Field getField(String fieldName) {
        Collection coll = (Collection)this.getFieldGroup().get(fieldName);
        if (coll != null) {
            return (Field)coll.iterator().next();
        }
        return null;
    }

    Map getAccessibleFieldGroup() {
        Map g = this.accessibleFieldGroup;
        return g != null ? g : (this.accessibleFieldGroup = this.accessibleFieldGroup());
    }

    Collection getAccessibleFields(String fieldName) {
        return (Collection)this.getAccessibleFieldGroup().get(fieldName);
    }

    Field getAccessibleField(String fieldName) {
        Collection coll = (Collection)this.getAccessibleFieldGroup().get(fieldName);
        if (coll != null) {
            return (Field)coll.iterator().next();
        }
        return null;
    }

    Map getMethodGroup() {
        Map g = this.methodGroup;
        return g != null ? g : (this.methodGroup = this.methodGroup());
    }

    Collection getMethods(String methodName) {
        return (Collection)this.getMethodGroup().get(methodName);
    }

    Method getMethod(String methodName, Class[] parameterTypes) {
        Collection coll = this.getMethods(methodName);
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (!Eval.isRefEquals(m.getParameterTypes(), parameterTypes)) continue;
                return m;
            }
        }
        return null;
    }

    Method getAssignmentMethod(String methodName, Class[] parameterTypes) {
        Collection coll = this.getMethods(methodName);
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (!HBeans.isAssignmentCompatible(m.getParameterTypes(), parameterTypes)) continue;
                return m;
            }
        }
        return null;
    }

    Map getAccessibleMethodGroup() {
        Map g = this.accessibleMethodGroup;
        return g != null ? g : (this.accessibleMethodGroup = this.accessibleMethodGroup());
    }

    Collection getAccessibleMethods(String methodName) {
        return (Collection)this.getAccessibleMethodGroup().get(methodName);
    }

    Method getAccessibleMethod(String methodName, Class[] parameterTypes) {
        Collection coll = this.getAccessibleMethods(methodName);
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (!Eval.isRefEquals(m.getParameterTypes(), parameterTypes)) continue;
                return m;
            }
        }
        return null;
    }

    Method getAssignmentAccessibleMethod(String methodName, Class[] parameterTypes) {
        Collection coll = this.getAccessibleMethods(methodName);
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (!HBeans.isAssignmentCompatible(m.getParameterTypes(), parameterTypes)) continue;
                return m;
            }
        }
        return null;
    }
}

