/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.cache;

import java.io.Serializable;
import java.util.WeakHashMap;
import shohaku.core.collections.Cache;
import shohaku.core.collections.cache.AbstractCache;

public class WeakHashCache
extends AbstractCache
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 874263548114519647L;
    static final int MAXIMUM_SIZE = 1024;
    static final int INITIAL_CAPACITY = 32;
    static final float LOAD_FACTOR = 0.75f;

    public WeakHashCache() {
        this(32);
    }

    public WeakHashCache(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakHashCache(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1024);
    }

    public WeakHashCache(Cache t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 32), 0.75f, 1024);
    }

    public WeakHashCache(int initialCapacity, float loadFactor, int maxSize) {
        this(initialCapacity, loadFactor, maxSize, null);
    }

    WeakHashCache(int initialCapacity, float loadFactor, int maxSize, Cache t) {
        super(new WeakHashMap(initialCapacity, loadFactor), maxSize, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this.mutex;
        synchronized (object) {
            WeakHashCache result = null;
            try {
                result = (WeakHashCache)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return result;
        }
    }
}

