/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.cache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import shohaku.core.collections.Cache;
import shohaku.core.collections.cache.AbstractCache;

public class InsertionOrderHashCache
extends AbstractCache
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5373535314673859093L;
    static final int MAXIMUM_SIZE = 1024;
    static final int INITIAL_CAPACITY = 32;
    static final float LOAD_FACTOR = 0.75f;

    public InsertionOrderHashCache() {
        this(32);
    }

    public InsertionOrderHashCache(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public InsertionOrderHashCache(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1024);
    }

    public InsertionOrderHashCache(Cache t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 32), 0.75f, 1024);
    }

    public InsertionOrderHashCache(int initialCapacity, float loadFactor, int maxSize) {
        this(initialCapacity, loadFactor, maxSize, null);
    }

    InsertionOrderHashCache(int initialCapacity, float loadFactor, int maxSize, Cache t) {
        super(new LinkedHashMap(initialCapacity, loadFactor, false), maxSize, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this.mutex;
        synchronized (object) {
            InsertionOrderHashCache result = null;
            try {
                result = (InsertionOrderHashCache)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return result;
        }
    }
}

