/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.cache;

import java.io.Serializable;
import java.util.LinkedHashMap;
import shohaku.core.collections.Cache;
import shohaku.core.collections.cache.AbstractCache;

public class AccessOrderHashCache
extends AbstractCache
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1734981299356517097L;
    static final int MAXIMUM_SIZE = 1024;
    static final int INITIAL_CAPACITY = 32;
    static final float LOAD_FACTOR = 0.75f;

    public AccessOrderHashCache() {
        this(32);
    }

    public AccessOrderHashCache(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public AccessOrderHashCache(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1024);
    }

    public AccessOrderHashCache(Cache t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 32), 0.75f, 1024);
    }

    public AccessOrderHashCache(int initialCapacity, float loadFactor, int maxSize) {
        this(initialCapacity, loadFactor, maxSize, null);
    }

    AccessOrderHashCache(int initialCapacity, float loadFactor, int maxSize, Cache t) {
        super(new LinkedHashMap(initialCapacity, loadFactor, true), maxSize, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this.mutex;
        synchronized (object) {
            AccessOrderHashCache result = null;
            try {
                result = (AccessOrderHashCache)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return result;
        }
    }
}

