/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import shohaku.core.collections.decorator.DecoratedList;
import shohaku.core.collections.decorator.DecoratedRandomAccessList;
import shohaku.core.lang.Predicate;

public class ListUtils {
    public static List unextendsList(List list) {
        if (list instanceof RandomAccess) {
            return new DecoratedRandomAccessList(list);
        }
        return new DecoratedList(list);
    }

    public static List addAll(List list, Iterator elements) {
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static List addAll(List list, int index, Iterator elements) {
        ListIterator i = list.listIterator(index);
        while (elements.hasNext()) {
            i.add(elements.next());
        }
        return list;
    }

    public static List addAll(List list, int index, Iterator elements, Predicate predicate) {
        ListIterator i = list.listIterator(index);
        while (elements.hasNext()) {
            Object o = elements.next();
            if (!predicate.evaluate(o)) continue;
            i.add(o);
        }
        return list;
    }

    public static List addAll(List list, int index, Collection elements, Predicate predicate) {
        return ListUtils.addAll(list, index, elements.iterator(), predicate);
    }
}

