/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import shohaku.core.lang.Eval;
import shohaku.core.lang.EvalSet;

public class ComparatorUtils {
    public static Comparator nullComparator(boolean nullLess) {
        final boolean _nullLess = nullLess;
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ComparatorUtils.compare((Comparable)o1, (Comparable)o2, _nullLess);
            }
        };
    }

    public static int compare(Comparable comp, Comparable comp2, boolean nullLess) {
        if (EvalSet.isAndNull(comp, comp2)) {
            return 0;
        }
        if (Eval.isNull(comp)) {
            return nullLess ? -1 : 1;
        }
        if (Eval.isNull(comp2)) {
            return nullLess ? 1 : -1;
        }
        return comp.compareTo(comp2);
    }

    public static int compare(Object o, Object o2, Comparator comp, boolean nullLess) {
        if (EvalSet.isAndNull(o, o2)) {
            return 0;
        }
        if (Eval.isNull(o)) {
            return nullLess ? -1 : 1;
        }
        if (Eval.isNull(o2)) {
            return nullLess ? 1 : -1;
        }
        return comp.compare(o, o2);
    }

    public static int compare(Collection comps, Collection comps2, boolean nullLess) {
        if (EvalSet.isAndNull(comps, comps2)) {
            return 0;
        }
        if (Eval.isNull(comps)) {
            return nullLess ? -1 : 1;
        }
        if (Eval.isNull(comps2)) {
            return nullLess ? 1 : -1;
        }
        if (!Eval.isEqualsSize(comps, comps2)) {
            return comps.size() > comps2.size() ? 1 : -1;
        }
        Iterator i = comps.iterator();
        Iterator i2 = comps2.iterator();
        while (i.hasNext() && i2.hasNext()) {
            int r = ComparatorUtils.compare((Comparable)i.next(), (Comparable)i2.next(), nullLess);
            if (0 == r) continue;
            return r > 0 ? 1 : -1;
        }
        return 0;
    }

    public static int compare(Collection comps, Collection comps2, Comparator comparator, boolean nullLess) {
        if (comps == null && null == comps2) {
            return 0;
        }
        if (comps == null) {
            return nullLess ? -1 : 1;
        }
        if (comps2 == null) {
            return nullLess ? 1 : -1;
        }
        if (!Eval.isEqualsSize(comps, comps2)) {
            return comps.size() > comps2.size() ? 1 : -1;
        }
        Iterator i = comps.iterator();
        Iterator i2 = comps2.iterator();
        while (i.hasNext() && i2.hasNext()) {
            int r = ComparatorUtils.compare(i.next(), i2.next(), comparator, nullLess);
            if (0 == r) continue;
            return r > 0 ? 1 : -1;
        }
        return 0;
    }
}

