/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import shohaku.core.collections.Box;
import shohaku.core.helpers.HHash;
import shohaku.core.lang.Eval;

public class BoxUtils {
    public static Box box(Object value) {
        return new ObjectBox(value);
    }

    public static Box arrayBox(Object[] value) {
        return new ObjectArrayBox(value);
    }

    public static Box identityBox(Object value) {
        return new IdentityBox(value);
    }

    public static Box identityArrayBox(Object[] value) {
        return new IdentityObjectArrayBox(value);
    }

    public static Box arrayBox(byte[] value) {
        return new ByteArrayBox(value);
    }

    public static Box arrayBox(short[] value) {
        return new ShortArrayBox(value);
    }

    public static Box arrayBox(int[] value) {
        return new IntArrayBox(value);
    }

    public static Box arrayBox(long[] value) {
        return new LongArrayBox(value);
    }

    public static Box arrayBox(float[] value) {
        return new FloatArrayBox(value);
    }

    public static Box arrayBox(double[] value) {
        return new DoubleArrayBox(value);
    }

    public static Box arrayBox(boolean[] value) {
        return new BooleanArrayBox(value);
    }

    static class BooleanArrayBox
    implements Box {
        private final boolean[] value;

        BooleanArrayBox(boolean[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof boolean[])) {
                return false;
            }
            boolean[] a = (boolean[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class DoubleArrayBox
    implements Box {
        private final double[] value;

        DoubleArrayBox(double[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof double[])) {
                return false;
            }
            double[] a = (double[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class FloatArrayBox
    implements Box {
        private final float[] value;

        FloatArrayBox(float[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof float[])) {
                return false;
            }
            float[] a = (float[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class LongArrayBox
    implements Box {
        private final long[] value;

        LongArrayBox(long[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof long[])) {
                return false;
            }
            long[] a = (long[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class IntArrayBox
    implements Box {
        private final int[] value;

        IntArrayBox(int[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof int[])) {
                return false;
            }
            int[] a = (int[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class ShortArrayBox
    implements Box {
        private final short[] value;

        ShortArrayBox(short[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof short[])) {
                return false;
            }
            short[] a = (short[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class ByteArrayBox
    implements Box {
        private final byte[] value;

        ByteArrayBox(byte[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof byte[])) {
                return false;
            }
            byte[] a = (byte[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class IdentityObjectArrayBox
    implements Box {
        private final Object[] value;

        IdentityObjectArrayBox(Object[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.identityHash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            return Eval.isRefEquals(this.value, a);
        }
    }

    static class IdentityBox
    implements Box {
        private final Object value;

        IdentityBox(Object v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            return this.value == v;
        }
    }

    static class ObjectArrayBox
    implements Box {
        private final Object[] value;

        ObjectArrayBox(Object[] v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            if (this.value == v) {
                return true;
            }
            if (v == null || !(v instanceof Object[])) {
                return false;
            }
            Object[] a = (Object[])v;
            return Eval.isEquals(this.value, a);
        }
    }

    static class ObjectBox
    implements Box {
        private final Object value;

        ObjectBox(Object v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return HHash.hash(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Box)) {
                return false;
            }
            Box e = (Box)o;
            Object v = e.getValue();
            return Eval.isEquals(this.value, v);
        }
    }
}

