/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans.dynamic;

import shohaku.core.beans.dynamic.BeanFactory;
import shohaku.core.beans.dynamic.ClassDesc;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectDestructionException;

public class SingletonBeanFactory
implements BeanFactory {
    final SingletonCache cache = new SingletonCache();
    private ClassDesc classDesc;
    private Class createSource;

    public void setClassDesc(ClassDesc classDesc) {
        this.classDesc = classDesc;
    }

    public void setCreateSource(Class createSource) {
        this.createSource = createSource;
    }

    public ClassDesc getClassDesc() {
        return this.classDesc;
    }

    public Class getCreateSource() {
        return this.createSource;
    }

    public Class getInstanceType() {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create() throws ObjectCreationException {
        try {
            SingletonCache singletonCache = this.cache;
            synchronized (singletonCache) {
                if (this.cache.instance == null) {
                    this.cache.instance = this.getClassDesc().createInstance(this.getCreateSource());
                }
                return this.cache.instance;
            }
        }
        catch (IntrospectionBeansException e) {
            throw new ObjectCreationException("create singleton instance. " + this.getClassDesc(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Object o) throws ObjectDestructionException {
        try {
            SingletonCache singletonCache = this.cache;
            synchronized (singletonCache) {
                if (this.cache.instance == null || this.cache.instance != o) {
                    throw new ObjectDestructionException("is not singleton instance." + o);
                }
                this.getClassDesc().destroyInstance(o);
            }
        }
        catch (IntrospectionBeansException e) {
            throw new ObjectDestructionException("destroy singleton instance. " + this.getClassDesc(), e);
        }
    }

    static final class SingletonCache {
        Object instance = null;

        SingletonCache() {
        }
    }
}

