/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans.dynamic;

import java.lang.reflect.Method;
import shohaku.core.beans.dynamic.ArgumentsDesc;
import shohaku.core.beans.dynamic.FeatureDesc;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;

public final class MethodDesc
extends FeatureDesc {
    public static final int METHOD = 0;
    public static final int SET_PROPERTY = 1;
    public static final int GET_PROPERTY = 2;
    private int type = 0;
    private String methodName;
    private ArgumentsDesc arguments;

    public MethodDesc() {
    }

    public MethodDesc(String methodName, ArgumentsDesc params, int type) {
        this.setMethodName(methodName);
        this.setArguments(params);
        this.setType(type);
    }

    public Object invoke(Class clazz) throws IntrospectionBeansException {
        return this.invoke(clazz, null);
    }

    public Object invoke(Object obj) throws IntrospectionBeansException {
        if (obj == null) {
            throw new NullPointerException("argument is null.");
        }
        return this.invoke(obj.getClass(), obj);
    }

    Object invoke(Class clazz, Object obj) throws IntrospectionBeansException {
        if (clazz == null) {
            throw new NullPointerException("argument is null.");
        }
        return this.invokeMethod(clazz, obj);
    }

    Object invokeMethod(Class clazz, Object obj) throws IntrospectionBeansException {
        if (clazz == null) {
            throw new NullPointerException("argument class is null.");
        }
        Method m = this.findInvokeMethod(clazz);
        if (m == null) {
            throw new IntrospectionBeansException(HLog.list("no such method. ", clazz, this.getMethodName(), this.getArgumentTypes()));
        }
        return HBeans.invokeMethod(obj, m, this.getArgumentValues());
    }

    Method findInvokeMethod(Class clazz) throws IntrospectionBeansException {
        switch (this.getType()) {
            case 0: {
                return HBeans.getAssignmentMethod(clazz, this.getMethodName(), this.getArgumentTypes());
            }
            case 1: {
                return HBeans.getAssignmentWriteProperty(clazz, this.getMethodName(), this.getArgumentTypes());
            }
            case 2: {
                return HBeans.getAssignmentWriteProperty(clazz, this.getMethodName(), this.getArgumentTypes());
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (!Eval.isRange(type, 0, 2)) {
            throw new IllegalArgumentException("illegal mathod type. " + type);
        }
        this.type = type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public ArgumentsDesc getArguments() {
        return this.arguments;
    }

    public void setArguments(ArgumentsDesc params) {
        this.arguments = params;
    }

    Object[] getArgumentValues() {
        return this.arguments == null ? new Object[]{} : this.arguments.getArgumentValues();
    }

    Class[] getArgumentTypes() {
        return this.arguments == null ? new Class[]{} : this.arguments.getArgumentTypes();
    }
}

