/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans.dynamic;

import shohaku.core.beans.dynamic.ArgumentsDesc;
import shohaku.core.beans.dynamic.FeatureDesc;
import shohaku.core.helpers.HBeans;
import shohaku.core.lang.IntrospectionBeansException;

public class FactoryMethodDesc
extends FeatureDesc {
    private String methodName;
    private ArgumentsDesc arguments;

    public FactoryMethodDesc() {
    }

    public FactoryMethodDesc(ArgumentsDesc params) {
        this.setArguments(params);
    }

    public FactoryMethodDesc(String methodName, ArgumentsDesc params) {
        this.setMethodName(methodName);
        this.setArguments(params);
    }

    public Object invoke(Class clazz) throws IntrospectionBeansException {
        return this.invoke(clazz, null);
    }

    public Object invoke(Object obj) throws IntrospectionBeansException {
        if (obj == null) {
            throw new NullPointerException("argument is null.");
        }
        return this.invoke(obj.getClass(), obj);
    }

    Object invoke(Class clazz, Object obj) throws IntrospectionBeansException {
        if (clazz == null) {
            throw new NullPointerException("argument is null.");
        }
        if (this.isConstructor()) {
            return this.invokeNewInstance(clazz);
        }
        return this.invokeMethod(clazz, obj);
    }

    Object invokeMethod(Class clazz, Object obj) throws IntrospectionBeansException {
        return HBeans.invokeMethod(obj, HBeans.getAssignmentMethod(clazz, this.getMethodName(), this.getArgumentTypes()), this.getArgumentValues());
    }

    Object invokeNewInstance(Class clazz) throws IntrospectionBeansException {
        return HBeans.newInstance(clazz, this.getArgumentTypes(), this.getArgumentValues());
    }

    public boolean isConstructor() {
        return this.getMethodName() == null || this.getMethodName().length() == 0;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public ArgumentsDesc getArguments() {
        return this.arguments;
    }

    public void setArguments(ArgumentsDesc params) {
        this.arguments = params;
    }

    Object[] getArgumentValues() {
        return this.arguments == null ? new Object[]{} : this.arguments.getArgumentValues();
    }

    Class[] getArgumentTypes() {
        return this.arguments == null ? new Class[]{} : this.arguments.getArgumentTypes();
    }
}

