/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import shohaku.core.beans.TypeTransformer;
import shohaku.core.functor.FTransformer;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HClass;
import shohaku.core.helpers.HLog;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.lang.feature.LogFeature;

public class DefaultTypeTransformer
implements TypeTransformer {
    private final LogFeature log = FeatureFactory.getLog(TypeTransformer.class);
    private final Map table = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultTypeTransformer() {
        this.init();
    }

    public FTransformer add(Class clazz, FTransformer transformer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(HLog.list("add transformer. ", clazz, transformer));
        }
        return this.table.put(this.entryClass(clazz), transformer);
    }

    public void clear() {
        this.table.clear();
    }

    public FTransformer remove(Class clazz) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(HLog.list("remove transformer. ", clazz));
        }
        return (FTransformer)this.table.remove(this.entryClass(clazz));
    }

    public int size() {
        return this.table.size();
    }

    public Iterator getTypes() {
        return this.table.keySet().iterator();
    }

    public boolean contains(Class clazz) {
        return this.table.containsKey(this.entryClass(clazz));
    }

    public FTransformer get(Class clazz) {
        return (FTransformer)this.table.get(this.entryClass(clazz));
    }

    public FTransformer find(Class clazz) {
        return this.findTransformer(clazz);
    }

    public Object transform(Class clazz, Object o) {
        return this.transform(clazz, o, Collections.EMPTY_MAP);
    }

    public Object transform(Class clazz, Object o, Map args) {
        FTransformer t;
        if (this.log.isTraceEnabled()) {
            this.log.trace(HLog.list("transform. ", clazz, o, args));
        }
        if ((t = this.find(clazz)) == null) {
            throw new IllegalArgumentException("not find class. " + clazz);
        }
        return t.transform(o, args);
    }

    protected void init() {
    }

    protected FTransformer findTransformer(Class clazz) {
        FTransformer t;
        if (this.log.isTraceEnabled()) {
            this.log.trace(HLog.list("find transformer. ", clazz));
        }
        if ((t = (FTransformer)this.table.get(this.entryClass(clazz))) == null) {
            Iterator i = this.table.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Class fromType = (Class)e.getKey();
                if (!HBeans.isAssignmentCompatible(fromType, clazz)) continue;
                t = (FTransformer)e.getValue();
            }
        }
        return t;
    }

    protected Class entryClass(Class clazz) {
        return HClass.box(clazz);
    }

    protected LogFeature getLog() {
        return this.log;
    }

    protected Map getTable() {
        return this.table;
    }
}

