/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang.feature.impl;

import org.apache.commons.logging.LogFactory;

import shohaku.core.lang.feature.LogFeature;
import shohaku.core.lang.feature.LogFeatureFactory;

/**
 * org.apache.commons.logging API へのプロキシとして働くログオブジェクトの、ファクトリを提供します。
 */
public class CommonsLogFeatureFactory implements LogFeatureFactory {

    public LogFeature getLogFeature(Class clazz) {
        return new CommonsLogFeature(LogFactory.getLog(clazz));
    }

    public LogFeature getLogFeature(String name) {
        return new CommonsLogFeature(LogFactory.getLog(name));
    }

}
