/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

/**
 * 変更可能な数値型のインターフェースを提供します。<br>
 * <br>
 * 変更可能な数値型のメンバーは java.lang.Number を継承するクラスとしては定義しません。<br>
 * これはその標準の実装が普遍性の特性を持つ java.lang.Number と、変更可能な数値型としての VariableNumber 型を別のデータ型として扱うためです。<br>
 * VariableNumber 型が java.lang.Number を継承すると、普遍性を前提に処理が行われる可能性があり、そのことが予測しがたい障害を発生させるのを避けるためです。
 */
public interface VariableNumber extends java.io.Serializable {

    /**
     * 現在の値の Number 型表現を返却します。
     * 
     * @return 現在の値の Number 型表現
     */
    Number getValue();

    /**
     * 指定の値を格納します。 値を丸めたり切り捨てたりすることもあります。
     * 
     * @param value
     *            格納する値
     * @throws NullPointerException
     *             引数が null の場合
     */
    void setValue(Number value);

    /**
     * 指定の値を格納します。 値を丸めたり切り捨てたりすることもあります。
     * 
     * @param value
     *            格納する値
     * @throws NullPointerException
     *             引数が null の場合
     */
    void setValue(VariableNumber value);

    /**
     * 指定された数値を byte 型として返します。値を丸めたり切り捨てたりすることもあります。
     * 
     * @return このオブジェクトが表す数値を byte 型に変換した値
     */
    byte byteValue();

    /**
     * 指定された値を short 型として返します。値を丸めたり切り捨てたりすることもあります。
     * 
     * @return このオブジェクトが表す数値を short 型に変換した値
     */
    short shortValue();

    /**
     * 指定された値を int 型として返します。値を丸めたり切り捨てたりすることもあります。
     * 
     * @return このオブジェクトが表す数値を int 型に変換した値
     */
    int intValue();

    /**
     * 指定された数値を long 型として返します。値を丸めたり切り捨てたりすることもあります。
     * 
     * @return このオブジェクトが表す数値を long 型に変換した値
     */
    long longValue();

    /**
     * 指定された数値を float 型として返します。値を丸めることもあります。
     * 
     * @return このオブジェクトが表す数値を float 型に変換した値
     */
    float floatValue();

    /**
     * 指定された値を double 型として返します。値を丸めることもあります。
     * 
     * @return このオブジェクトが表す数値を double 型に変換した値
     */
    double doubleValue();

}
