/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

import java.util.Collection;
import java.util.Iterator;

/**
 * 文字列の結合するショートカット関数群を提供します。
 */
public class Concat {

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @param cs8
     *            値８
     * @param cs9
     *            値９
     * @param cs10
     *            値１０
     * @param cs11
     *            値１１
     * @param cs12
     *            値１２
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7, CharSequence cs8, CharSequence cs9, CharSequence cs10, CharSequence cs11, CharSequence cs12) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length() + cs8.length() + cs9.length() + cs10.length() + cs11.length() + cs12.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @param cs8
     *            値８
     * @param cs9
     *            値９
     * @param cs10
     *            値１０
     * @param cs11
     *            値１１
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7, CharSequence cs8, CharSequence cs9, CharSequence cs10, CharSequence cs11) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length() + cs8.length() + cs9.length() + cs10.length() + cs11.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @param cs8
     *            値８
     * @param cs9
     *            値９
     * @param cs10
     *            値１０
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7, CharSequence cs8, CharSequence cs9, CharSequence cs10) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length() + cs8.length() + cs9.length() + cs10.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @param cs8
     *            値８
     * @param cs9
     *            値９
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7, CharSequence cs8, CharSequence cs9) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length() + cs8.length() + cs9.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @param cs8
     *            値８
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7, CharSequence cs8) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length() + cs8.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @param cs7
     *            値７
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6, CharSequence cs7) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length() + cs7.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @param cs6
     *            値６
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5, CharSequence cs6) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length() + cs6.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @param cs5
     *            値５
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4, CharSequence cs5) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length() + cs5.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @param cs4
     *            値４
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3, CharSequence cs4) {
        return cs1.length() + cs2.length() + cs3.length() + cs4.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @param cs3
     *            値３
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2, CharSequence cs3) {
        return cs1.length() + cs2.length() + cs3.length();
    }

    /**
     * 引数の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param cs1
     *            値１
     * @param cs2
     *            値２
     * @return 連結した文字数
     */
    public static int size(CharSequence cs1, CharSequence cs2) {
        return cs1.length() + cs2.length();
    }

    /**
     * 引数の全要素の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param a
     *            文字シーケンスの配列
     * @return 連結した文字数
     */
    public static int size(CharSequence[] a) {
        int size = 0;
        for (int i = 0; i < a.length; i++) {
            size += (null != a[i]) ? a[i].length() : 0;
        }
        return size;
    }

    /**
     * 引数の全要素の文字シーケンスを連結した文字数を算出して返却します。
     * 
     * @param coll
     *            文字シーケンスのコレクション
     * @return 連結した文字数
     */
    public static int size(Collection coll) {
        int size = 0;
        for (Iterator i = coll.iterator(); i.hasNext();) {
            final CharSequence e = (CharSequence) i.next();
            size += (null != e) ? e.length() : 0;
        }
        return size;
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @param o12
     *            値１２
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11, Object o12) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        final String s11 = String.valueOf(o11);
        final String s12 = String.valueOf(o12);
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10).append(s11).append(s12);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        final String s11 = String.valueOf(o11);
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10).append(s11);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final int len = size(s1, s2, s3, s4, s5, s6, s7);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final int len = size(s1, s2, s3, s4, s5, s6);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4, Object o5) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final int len = size(s1, s2, s3, s4, s5);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3, Object o4) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final int len = size(s1, s2, s3, s4);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3).append(s4);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2, Object o3) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final int len = size(s1, s2, s3);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2).append(s3);
    }

    /**
     * 引数のオブジェクトを指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object o1, Object o2) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final int len = size(s1, s2);
        buff.ensureCapacity(buff.length() + len);
        return buff.append(s1).append(s2);
    }

    /**
     * 引数の配列の全要素を指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param a
     *            値となるオブジェクトの配列
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Object[] a) {
        for (int i = 0; i < a.length; i++) {
            buff.append(a[i]);
        }
        return buff;
    }

    /**
     * 引数のコレクションの全要素を指定の文字列バッファに追加して返却します。
     * 
     * @param buff
     *            文字列バッファ
     * @param coll
     *            値となるオブジェクトのコレクション
     * @return 引数の文字列バッファ
     */
    public static StringBuffer add(StringBuffer buff, Collection coll) {
        for (Iterator i = coll.iterator(); i.hasNext();) {
            buff.append(i.next());
        }
        return buff;
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @param s8
     *            値８
     * @param s9
     *            値９
     * @param s10
     *            値１０
     * @param s11
     *            値１１
     * @param s12
     *            値１２
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11, String s12) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10).append(s11).append(s12).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @param s8
     *            値８
     * @param s9
     *            値９
     * @param s10
     *            値１０
     * @param s11
     *            値１１
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10, String s11) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10).append(s11).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @param s8
     *            値８
     * @param s9
     *            値９
     * @param s10
     *            値１０
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @param s8
     *            値８
     * @param s9
     *            値９
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8, s9);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @param s8
     *            値８
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7, s8);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @param s7
     *            値７
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        final int len = size(s1, s2, s3, s4, s5, s6, s7);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @param s6
     *            値６
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5, String s6) {
        final int len = size(s1, s2, s3, s4, s5, s6);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @param s5
     *            値５
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4, String s5) {
        final int len = size(s1, s2, s3, s4, s5);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).append(s5).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @param s4
     *            値４
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3, String s4) {
        final int len = size(s1, s2, s3, s4);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).append(s4).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @param s3
     *            値３
     * @return 連結した文字列
     */
    public static String get(String s1, String s2, String s3) {
        final int len = size(s1, s2, s3);
        final StringBuffer buff = new StringBuffer(len);
        return buff.append(s1).append(s2).append(s3).toString();
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param s1
     *            値１
     * @param s2
     *            値２
     * @return 連結した文字列
     */
    public static String get(String s1, String s2) {
        return String.valueOf(s1).concat(String.valueOf(s2));
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @param o12
     *            値１２
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11, Object o12) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        final String s11 = String.valueOf(o11);
        final String s12 = String.valueOf(o12);
        return get(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        final String s11 = String.valueOf(o11);
        return get(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        final String s10 = String.valueOf(o10);
        return get(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        final String s9 = String.valueOf(o9);
        return get(s1, s2, s3, s4, s5, s6, s7, s8, s9);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        final String s8 = String.valueOf(o8);
        return get(s1, s2, s3, s4, s5, s6, s7, s8);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        final String s7 = String.valueOf(o7);
        return get(s1, s2, s3, s4, s5, s6, s7);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        final String s6 = String.valueOf(o6);
        return get(s1, s2, s3, s4, s5, s6);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4, Object o5) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        final String s5 = String.valueOf(o5);
        return get(s1, s2, s3, s4, s5);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3, Object o4) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        final String s4 = String.valueOf(o4);
        return get(s1, s2, s3, s4);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2, Object o3) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        final String s3 = String.valueOf(o3);
        return get(s1, s2, s3);
    }

    /**
     * 引数のオブジェクトを文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @return 連結した文字列
     */
    public static String get(Object o1, Object o2) {
        final String s1 = String.valueOf(o1);
        final String s2 = String.valueOf(o2);
        return s1.concat(s2);
    }

    /**
     * 引数の配列の全要素を文字列として連結して返却します。
     * 
     * @param a
     *            値となるオブジェクトの配列
     * @return 連結した文字列
     */
    public static String get(Object[] a) {
        return add(new StringBuffer(16 * a.length), a).toString();
    }

    /**
     * 引数のコレクションの全要素を文字列として連結して返却します。
     * 
     * @param coll
     *            値となるオブジェクトのコレクション
     * @return 連結した文字列
     */
    public static String get(Collection coll) {
        return add(new StringBuffer(16 * coll.size()), coll).toString();
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @param o12
     *            値１２
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11, Object o12) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7), nvl(o8), nvl(o9), nvl(o10), nvl(o11), nvl(o12));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @param o11
     *            値１１
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10, Object o11) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7), nvl(o8), nvl(o9), nvl(o10), nvl(o11));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @param o10
     *            値１０
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9, Object o10) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7), nvl(o8), nvl(o9), nvl(o10));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @param o9
     *            値９
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7), nvl(o8), nvl(o9));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @param o8
     *            値８
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7), nvl(o8));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @param o7
     *            値７
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6), nvl(o7));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @param o6
     *            値６
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5), nvl(o6));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @param o5
     *            値５
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4), nvl(o5));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @param o4
     *            値４
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3, Object o4) {
        return get(nvl(o1), nvl(o2), nvl(o3), nvl(o4));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @param o3
     *            値３
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2, Object o3) {
        return get(nvl(o1), nvl(o2), nvl(o3));
    }

    /**
     * 引数のオブジェクトを null を含めずに文字列として連結して返却します。
     * 
     * @param o1
     *            値１
     * @param o2
     *            値２
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object o1, Object o2) {
        return nvl(o1).concat(nvl(o2));
    }

    /**
     * 引数の配列の全要素を null を含めずに文字列として連結して返却します。
     * 
     * @param a
     *            値となるオブジェクトの配列
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Object[] a) {
        final StringBuffer sb = new StringBuffer(16 * a.length);
        for (int i = 0; i < a.length; i++) {
            sb.append(nvl(a[i]));
        }
        return sb.toString();
    }

    /**
     * 引数のコレクションの全要素を null を含めずに文字列として連結して返却します。
     * 
     * @param coll
     *            値となるオブジェクトのコレクション
     * @return null を含めずに連結した文字列
     */
    public static String nvl(Collection coll) {
        final StringBuffer sb = new StringBuffer(16 * coll.size());
        for (Iterator i = coll.iterator(); i.hasNext();) {
            sb.append(nvl(i.next()));
        }
        return sb.toString();
    }

    private static String nvl(Object o) {
        return (o == null) ? "" : String.valueOf(o);
    }

}
