/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.lang;

/**
 * 汎用 クロージャのインタフェースを提供します。 <br>
 * <br>
 * 動的言語に広く見られる、クロージャやブロックと呼ばれる概念を Java でエミュレートする機能です。<br>
 * ファンクタと似ていますが、ここではファンクタは特定の用途を持つ遅延関数として別概念で定義しています。<br>
 * このインタフェースは多くの場合に無名クラスとして定義されます。 <br>
 * 処理は全て evaluate(Object) 内で完結します。
 */
public interface Closure {

    /**
     * 処理の実行コードを定義します。
     * 
     * @param p
     *            パラメータ
     * @return 処理結果
     */
    Object evaluate(Object p);

}
