/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.helpers;

import shohaku.core.lang.Concat;

/**
 * ログ文字列を生成するヘルパーメソッド群を提供します。
 */
public class HLog {

    /**
     * オブジェクトの深層の情報を含む拡張書式の文字列表現を生成して返却します。
     * 
     * @param o
     *            オブジェクト
     * @return 拡張書式の文字列表現
     */
    public static String arrays(Object o) {
        return LogHelper.arrays(o);
    }

    /**
     * オブジェクトが配列の場合にリスト書式の文字列表現を生成し、以外は String.valueOf で生成した文字列を返却します。
     * 
     * @param o
     *            オブジェクト
     * @return 文字列表現
     */
    public static String array(Object o) {
        return LogHelper.array(o);
    }

    /**
     * オブジェクトのクラスの文字列を生成します。
     * 
     * @param o
     *            要素
     * @return クラス文字列
     */
    public static String clazz(Object o) {
        return (null == o) ? String.valueOf(null) : o.getClass().toString();
    }

    /**
     * オブジェクトのクラスの文字列を生成します。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素
     * @return クラス文字列
     */
    public static String clazz(String msg, Object o) {
        return Concat.get(msg, clazz(o));
    }

    /**
     * ログメッセージを生成します。
     * 
     * @param o
     *            要素
     * @return ログメッセージ
     */
    public static String out(Object o) {
        return LogHelper.array(o);
    }

    /**
     * ログメッセージを生成します。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素
     * @return ログメッセージ
     */
    public static String list(String msg, Object o) {
        return Concat.get(msg, out(o));
    }

    /**
     * ログメッセージを生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @return ログメッセージ
     */
    public static String list(String msg, Object o, Object o1) {
        return Concat.get(msg, out(o), ", ", out(o1));
    }

    /**
     * ログメッセージを生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @return ログメッセージ
     */
    public static String list(String msg, Object o, Object o1, Object o2) {
        return Concat.get(msg, out(o), ", ", out(o1), ", ", out(o2));
    }

    /**
     * ログメッセージを生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @return ログメッセージ
     */
    public static String list(String msg, Object o, Object o1, Object o2, Object o3) {
        return Concat.get(msg, out(o), ", ", out(o1), ", ", out(o2), ", ", out(o3));
    }

    /**
     * ログメッセージを生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @param o4
     *            要素５
     * @return ログメッセージ
     */
    public static String list(String msg, Object o, Object o1, Object o2, Object o3, Object o4) {
        return Concat.get(msg, out(o), ", ", out(o1), ", ", out(o2), ", ", out(o3), ", ", out(o4));
    }

    /**
     * ログメッセージを生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @param o4
     *            要素５
     * @param o5
     *            要素６
     * @return ログメッセージ
     */
    public static String list(String msg, Object o, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return Concat.get(msg, out(o), ", ", out(o1), ", ", out(o2), ", ", out(o3), ", ", out(o4), ", ", out(o5));
    }

    /**
     * 数値の範囲に関するログメッセージを生成します。
     * 
     * @param msg
     *            メッセージ
     * @param size
     *            サイズ
     * @param from
     *            開始値
     * @param to
     *            終了値
     * @return 数値の範囲に関するログメッセージ
     */
    public static String range(String msg, int size, int from, int to) {
        return (new StringBuffer(16 * 3)).append(msg).append(" size=").append(size).append(", from=").append(from).append(", to=").append(to).toString();
    }

    /**
     * 数値の範囲に関するログメッセージを生成します。
     * 
     * @param msg
     *            メッセージ
     * @param size
     *            サイズ
     * @param from
     *            開始値
     * @param to
     *            終了値
     * @param o
     *            追加要素１
     * @return 数値の範囲に関するログメッセージ
     */
    public static String range(String msg, int size, int from, int to, Object o) {
        return (new StringBuffer(16 * 3)).append(msg).append(" size=").append(size).append(", from=").append(from).append(", to=").append(to).append(out(o)).toString();
    }

}
