/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.functor;

import java.util.Map;

/**
 * オブジェクトの構造を変換する機能を提供します。 <br>
 * <br>
 * このインターフェースの一般契約として、引数が変換の実行の結果に何らかの副作用を受けない事を保証する必要が有ります。 <br>
 * この契約事項は呼出側が安全に変換処理を行うために必要です。<br>
 * <br>
 * 処理は全て transform(Object) 内で完結します。 <br>
 * このインターフェースは複数のスレッドからの非同期な実行が前提と為っています。<br>
 * 実装クラスはスレッドセーフである必要があります。
 */
public interface FTransformer {

    /**
     * 変換を実行し生成されたオブジェクトを返却します。<br>
     * 変換パラメータが無い場合は空マップが渡されます、null は許容されません。<br>
     * 変換に失敗した場合は FunctorException を発生させます。<br>
     * 
     * @param o
     *            変換対象となる値
     * @param args
     *            変換パラメータ
     * @return 変換されたオブジェクト
     * @throws FunctorException
     *             予測外の問題から変換に失敗した場合
     */
    Object transform(Object o, Map args);

}