/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.functor;

/**
 * 情報を検索する機能を提供します。 <br>
 * <br>
 * このインターフェースの一般契約として、引数が検索の実行の結果に何らかの副作用を受けない事を保証する必要が有ります。 <br>
 * この契約事項は呼出側が安全に検索を行うために必要です。<br>
 * <br>
 * 処理は全て search(Object o) 内で完結します。 <br>
 * このインターフェースは複数のスレッドからの非同期な実行が前提と為っています。<br>
 * 実装クラスはスレッドセーフである必要があります。
 */
public interface FSearcher {

    /**
     * 処理を実行し発見されたオブジェクトを返却します。<br>
     * 発見出来ない場合 null 返却します。<br>
     * 検索に失敗した場合は FunctorException を発生させます。<br>
     * 
     * @param o
     *            検索に関する情報を格納するオブジェクト
     * @return 発見された値、発見出来ない場合 null
     * @throws FunctorException
     *             予測外の問題から検索に失敗した場合
     */
    Object search(Object o);

}