/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections.decorator;

import java.util.Comparator;
import java.util.SortedMap;

/**
 * 指定されたソートマップを装飾するビューを提供します。 <br>
 * <br>
 * このクラスはソートマップの実装を隠蔽する目的や、装飾クラスの基底実装の役割を持ちます。<br>
 * 装飾されたソートマップが直列化可能の場合は直列化可能です。
 */
public class DecoratedSortedMap extends DecoratedMap implements SortedMap {

    /* serialVersionUID */
    private static final long serialVersionUID = -5886340488347320402L;

    /** 基となるソートマップ。 */
    protected final SortedMap sortedMap;

    /**
     * ラップするマップを指定して初期化します。
     * 
     * @param m
     *            ラップするマップ
     */
    public DecoratedSortedMap(SortedMap m) {
        super(m);
        this.sortedMap = m;
    }

    public Object firstKey() {
        return sortedMap.firstKey();
    }

    public Object lastKey() {
        return sortedMap.lastKey();
    }

    public Comparator comparator() {
        return sortedMap.comparator();
    }

    public SortedMap headMap(Object toElement) {
        return sortedMap.headMap(toElement);
    }

    public SortedMap tailMap(Object fromElement) {
        return sortedMap.tailMap(fromElement);
    }

    public SortedMap subMap(Object fromElement, Object toElement) {
        return sortedMap.subMap(fromElement, toElement);
    }

}
