/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections;

/**
 * キーと値を対のオブジェクトを格納する箱の機能を提供します。
 */
public interface MapBox {

    /**
     * このマップボックスのキーを返却します。
     * 
     * @return このマップボックスのキー
     */
    Object getKey();

    /**
     * このマップボックスの値を返却します。
     * 
     * @return このマップボックスの値
     */
    Object getValue();

    /**
     * このマップボックスの値を変更し、既存の値を返却します。 <br>
     * 
     * @param value
     *            新たな値
     * @return 既存の値
     */
    Object setValue(Object value);

    /**
     * ハッシュコード値を返却します。 <br>
     * getKey() で返されるオブジェクトがその算出対象となります。
     * 
     * @return ハッシュコード値
     */
    int hashCode();

    /**
     * 同値性を比較します。 <br>
     * getKey() で返されるオブジェクトがその対象となります。 <br>
     * 検証の一般契約として、引数が MapBox の実装クラスであり、<br>
     * 比較値が getKey() で返されるオブジェクトと同値と判断出来る事が条件となります。
     * 
     * @param o
     *            比較するオブジェクト
     * @return 等しい場合は true
     */
    boolean equals(Object o);

}
