/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.collections;

/**
 * 単一のオブジェクトを格納する箱の機能を提供します。
 */
public interface Box {

    /**
     * このボックスの値を返却します。
     * 
     * @return このボックスの値
     */
    Object getValue();

    /**
     * ハッシュコード値を返却します。<br>
     * getValue() で返されるオブジェクトがその算出対象となります。
     * 
     * @return ハッシュコード値
     */
    int hashCode();

    /**
     * 同値性を比較します。<br>
     * getValue() で返されるオブジェクトがその対象となります。<br>
     * 検証の一般契約として、引数が Box の実装クラスであり、<br>
     * 比較値が getValue() で返されるオブジェクトと同値と判断出来る事が条件となります。
     * 
     * @param o
     *            比較するオブジェクト
     * @return 等しい場合は true
     */
    boolean equals(Object o);

}
