/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.core.beans.dynamic;

import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ObjectCreationProxy;
import shohaku.core.lang.ObjectDestructionException;

/**
 * ClassDesc から実装固有の基準でインスタンスを生成する機能を提供します。
 */
public interface BeanFactory extends ObjectCreationProxy {

    /**
     * クラス情報を返却します。
     * 
     * @return クラス情報
     */
    ClassDesc getClassDesc();

    /**
     * 生成基のオブジェクト型を返却します。<br>
     * 実際に生成されるオブジェクト型とは一致しない場合が有り得ます。
     * 
     * @return 生成基のオブジェクト型
     */
    Class getCreateSource();

    /**
     * 生成されるオブジェクト型を返却します。<br>
     * 型が不明解の場合は Object.class を返却します。
     * 
     * @return 生成するオブジェクト型
     * @see shohaku.core.lang.ObjectCreationProxy#getInstanceType()
     */
    Class getInstanceType();

    /**
     * インスタンスを生成して返却します。
     * 
     * @return 生成されたインスタンス
     * @throws ObjectCreationException
     *             オブジェクトの生成に失敗した場合
     * @see shohaku.core.lang.ObjectCreationProxy#create()
     */
    Object create() throws ObjectCreationException;

    /**
     * インスタンスを破棄する処理を実行します。
     * 
     * @param o
     *            破棄するインスタンス
     * @throws ObjectDestructionException
     *             オブジェクトの破棄に失敗した場合
     * @see shohaku.core.lang.ObjectCreationProxy#destroy(java.lang.Object)
     */
    void destroy(Object o) throws ObjectDestructionException;

}
