/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.HLog;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlUnaryOperatorParser {
    OgdlUnaryOperatorParser() {
    }

    static Object evaluateBitwiseComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.off.increment();
        Object o = OgdlRuntime.evaluate(ev);
        if (o instanceof Byte) {
            byte num = (Byte)o;
            return Boxing.box((int)(~num));
        }
        if (o instanceof Short) {
            short num = (Short)o;
            return Boxing.box((int)(~num));
        }
        if (o instanceof Integer) {
            int num = (Integer)o;
            return Boxing.box(~num);
        }
        if (o instanceof Long) {
            long num = (Long)o;
            return Boxing.box(num ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (o instanceof Float) {
            throw new OgdlSyntaxException(ev, HLog.log("value is not integer. ", o));
        }
        if (o instanceof Double) {
            throw new OgdlSyntaxException(ev, HLog.log("value is not integer. ", o));
        }
        if (o instanceof BigInteger) {
            BigInteger num = (BigInteger)o;
            return num.not();
        }
        if (o instanceof BigDecimal) {
            throw new OgdlSyntaxException(ev, HLog.log("value is not integer. ", o));
        }
        throw new OgdlSyntaxException(ev, HLog.log("value is not Number. ", o));
    }

    static Object evaluateLogicalComplement(OgdlEvent ev) throws OgdlSyntaxException {
        ev.off.increment();
        Object o = OgdlRuntime.evaluate(ev);
        if (!(o instanceof Boolean)) {
            throw new OgdlSyntaxException(ev, HLog.log("value is not Boolean. ", o));
        }
        return Boolean.TRUE.equals(o) ? Boolean.FALSE : Boolean.TRUE;
    }

    static Object evaluateUnaryMinus(OgdlEvent ev) throws OgdlSyntaxException {
        ev.off.increment();
        Object o = OgdlRuntime.evaluate(ev);
        if (o instanceof Byte) {
            byte num = (Byte)o;
            return Boxing.box(-num);
        }
        if (o instanceof Short) {
            short num = (Short)o;
            return Boxing.box(-num);
        }
        if (o instanceof Integer) {
            int num = (Integer)o;
            return Boxing.box(-num);
        }
        if (o instanceof Long) {
            long num = (Long)o;
            return Boxing.box(-num);
        }
        if (o instanceof Float) {
            float num = ((Float)o).floatValue();
            return Boxing.box(-num);
        }
        if (o instanceof Double) {
            double num = (Double)o;
            return Boxing.box(-num);
        }
        if (o instanceof BigInteger) {
            BigInteger num = (BigInteger)o;
            return num.negate();
        }
        if (o instanceof BigDecimal) {
            BigDecimal num = (BigDecimal)o;
            return num.negate();
        }
        throw new OgdlSyntaxException(ev, HLog.log("value is not Number. ", o));
    }
}

