/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import shohaku.ogdl.HEval;
import shohaku.ogdl.HLog;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlSyntax {
    static final int UPPER = 1;
    static final int LOWER = 2;
    static final int SPACE = 4;
    static final int PUNCT = 8;
    static final int CNTRL = 16;
    static final int DIGIT = 32;
    static final int HEX = 64;
    static final int OCTAL = 128;
    static final int FLOAT = 256;
    static final int UNDER = 0x100000;
    static final int DOT = 0x200000;
    static final int DOLLAR = 0x400000;
    static final int COLON = 0x800000;
    static final int MINUS = 0x1000000;
    static final int ISOTIME = 0x2000000;
    static final int ALPHA = 3;
    static final int ALNUM = 35;
    static final int GRAPH = 43;
    static final int MEMBER = 1048611;
    static final int MEMBER_BEGIN = 0x100003;
    static final int CLAZZ = 7340067;
    static final int NUMBER = 480;
    static final int BLANK = 20;
    static final int FUNC = 9437219;
    static final int OPERATOR = 10;
    static final int DIFFERENCE = 17826275;
    static final int DATETIME = 60817440;
    private static final int[] GROUP = new int[255];

    static {
        OgdlSyntax.GROUP[0] = 16;
        OgdlSyntax.GROUP[1] = 16;
        OgdlSyntax.GROUP[2] = 16;
        OgdlSyntax.GROUP[3] = 16;
        OgdlSyntax.GROUP[4] = 16;
        OgdlSyntax.GROUP[5] = 16;
        OgdlSyntax.GROUP[6] = 16;
        OgdlSyntax.GROUP[7] = 16;
        OgdlSyntax.GROUP[8] = 16;
        OgdlSyntax.GROUP[9] = 20;
        OgdlSyntax.GROUP[10] = 20;
        OgdlSyntax.GROUP[11] = 20;
        OgdlSyntax.GROUP[12] = 20;
        OgdlSyntax.GROUP[13] = 20;
        OgdlSyntax.GROUP[14] = 16;
        OgdlSyntax.GROUP[15] = 16;
        OgdlSyntax.GROUP[16] = 16;
        OgdlSyntax.GROUP[17] = 16;
        OgdlSyntax.GROUP[18] = 16;
        OgdlSyntax.GROUP[19] = 16;
        OgdlSyntax.GROUP[20] = 16;
        OgdlSyntax.GROUP[21] = 16;
        OgdlSyntax.GROUP[22] = 16;
        OgdlSyntax.GROUP[23] = 16;
        OgdlSyntax.GROUP[24] = 16;
        OgdlSyntax.GROUP[25] = 16;
        OgdlSyntax.GROUP[26] = 16;
        OgdlSyntax.GROUP[27] = 16;
        OgdlSyntax.GROUP[28] = 16;
        OgdlSyntax.GROUP[29] = 16;
        OgdlSyntax.GROUP[30] = 16;
        OgdlSyntax.GROUP[31] = 16;
        OgdlSyntax.GROUP[32] = 4;
        OgdlSyntax.GROUP[33] = 8;
        OgdlSyntax.GROUP[34] = 8;
        OgdlSyntax.GROUP[35] = 8;
        OgdlSyntax.GROUP[36] = 0x400008;
        OgdlSyntax.GROUP[37] = 8;
        OgdlSyntax.GROUP[38] = 8;
        OgdlSyntax.GROUP[39] = 8;
        OgdlSyntax.GROUP[40] = 8;
        OgdlSyntax.GROUP[41] = 8;
        OgdlSyntax.GROUP[42] = 8;
        OgdlSyntax.GROUP[43] = 264;
        OgdlSyntax.GROUP[44] = 8;
        OgdlSyntax.GROUP[45] = 0x1000108;
        OgdlSyntax.GROUP[46] = 2097416;
        OgdlSyntax.GROUP[47] = 8;
        OgdlSyntax.GROUP[48] = 480;
        OgdlSyntax.GROUP[49] = 480;
        OgdlSyntax.GROUP[50] = 480;
        OgdlSyntax.GROUP[51] = 480;
        OgdlSyntax.GROUP[52] = 480;
        OgdlSyntax.GROUP[53] = 480;
        OgdlSyntax.GROUP[54] = 480;
        OgdlSyntax.GROUP[55] = 480;
        OgdlSyntax.GROUP[56] = 352;
        OgdlSyntax.GROUP[57] = 352;
        OgdlSyntax.GROUP[58] = 0x800008;
        OgdlSyntax.GROUP[59] = 8;
        OgdlSyntax.GROUP[60] = 8;
        OgdlSyntax.GROUP[61] = 8;
        OgdlSyntax.GROUP[62] = 8;
        OgdlSyntax.GROUP[63] = 8;
        OgdlSyntax.GROUP[64] = 8;
        OgdlSyntax.GROUP[65] = 65;
        OgdlSyntax.GROUP[66] = 65;
        OgdlSyntax.GROUP[67] = 65;
        OgdlSyntax.GROUP[68] = 65;
        OgdlSyntax.GROUP[69] = 321;
        OgdlSyntax.GROUP[70] = 65;
        OgdlSyntax.GROUP[71] = 1;
        OgdlSyntax.GROUP[72] = 1;
        OgdlSyntax.GROUP[73] = 1;
        OgdlSyntax.GROUP[74] = 1;
        OgdlSyntax.GROUP[75] = 1;
        OgdlSyntax.GROUP[76] = 1;
        OgdlSyntax.GROUP[77] = 1;
        OgdlSyntax.GROUP[78] = 1;
        OgdlSyntax.GROUP[79] = 1;
        OgdlSyntax.GROUP[80] = 1;
        OgdlSyntax.GROUP[81] = 1;
        OgdlSyntax.GROUP[82] = 1;
        OgdlSyntax.GROUP[83] = 1;
        OgdlSyntax.GROUP[84] = 0x2000001;
        OgdlSyntax.GROUP[85] = 1;
        OgdlSyntax.GROUP[86] = 1;
        OgdlSyntax.GROUP[87] = 1;
        OgdlSyntax.GROUP[88] = 65;
        OgdlSyntax.GROUP[89] = 1;
        OgdlSyntax.GROUP[90] = 1;
        OgdlSyntax.GROUP[91] = 8;
        OgdlSyntax.GROUP[92] = 8;
        OgdlSyntax.GROUP[93] = 8;
        OgdlSyntax.GROUP[94] = 8;
        OgdlSyntax.GROUP[95] = 0x100008;
        OgdlSyntax.GROUP[96] = 8;
        OgdlSyntax.GROUP[97] = 66;
        OgdlSyntax.GROUP[98] = 66;
        OgdlSyntax.GROUP[99] = 66;
        OgdlSyntax.GROUP[100] = 66;
        OgdlSyntax.GROUP[101] = 322;
        OgdlSyntax.GROUP[102] = 66;
        OgdlSyntax.GROUP[103] = 2;
        OgdlSyntax.GROUP[104] = 2;
        OgdlSyntax.GROUP[105] = 2;
        OgdlSyntax.GROUP[106] = 2;
        OgdlSyntax.GROUP[107] = 2;
        OgdlSyntax.GROUP[108] = 2;
        OgdlSyntax.GROUP[109] = 2;
        OgdlSyntax.GROUP[110] = 2;
        OgdlSyntax.GROUP[111] = 2;
        OgdlSyntax.GROUP[112] = 2;
        OgdlSyntax.GROUP[113] = 2;
        OgdlSyntax.GROUP[114] = 2;
        OgdlSyntax.GROUP[115] = 2;
        OgdlSyntax.GROUP[116] = 2;
        OgdlSyntax.GROUP[117] = 2;
        OgdlSyntax.GROUP[118] = 2;
        OgdlSyntax.GROUP[119] = 2;
        OgdlSyntax.GROUP[120] = 66;
        OgdlSyntax.GROUP[121] = 2;
        OgdlSyntax.GROUP[122] = 2;
        OgdlSyntax.GROUP[123] = 8;
        OgdlSyntax.GROUP[124] = 8;
        OgdlSyntax.GROUP[125] = 8;
        OgdlSyntax.GROUP[126] = 8;
        OgdlSyntax.GROUP[127] = 16;
    }

    OgdlSyntax() {
    }

    static int getGroup(int ch) {
        return OgdlSyntax.isAscii(ch) ? GROUP[ch] : 0;
    }

    static boolean isGroup(int ch, int type) {
        return (OgdlSyntax.getGroup(ch) & type) != 0;
    }

    static boolean isAscii(int ch) {
        return (ch & 0xFFFFFF80) == 0;
    }

    static boolean isGraph(int ch) {
        return OgdlSyntax.isGroup(ch, 43);
    }

    static boolean isPunct(int ch) {
        return OgdlSyntax.isGroup(ch, 8);
    }

    static boolean isSpace(int ch) {
        return OgdlSyntax.isGroup(ch, 4);
    }

    static boolean isDigit(int ch) {
        return OgdlSyntax.isGroup(ch, 32);
    }

    static boolean isHexDigit(int ch) {
        return OgdlSyntax.isGroup(ch, 64);
    }

    static boolean isOctalDigits(int ch) {
        return OgdlSyntax.isGroup(ch, 128);
    }

    static boolean isFloatingPoint(int ch) {
        return OgdlSyntax.isGroup(ch, 256);
    }

    static boolean isCntrl(int ch) {
        return OgdlSyntax.isGroup(ch, 16);
    }

    static boolean isLower(int ch) {
        return OgdlSyntax.isGroup(ch, 2);
    }

    static boolean isUpper(int ch) {
        return OgdlSyntax.isGroup(ch, 1);
    }

    static boolean isMenber(int ch) {
        return OgdlSyntax.isGroup(ch, 1048611);
    }

    static boolean isClazz(int ch) {
        return OgdlSyntax.isGroup(ch, 7340067);
    }

    static boolean isNumber(int ch) {
        return OgdlSyntax.isGroup(ch, 480);
    }

    static boolean isBlank(int ch) {
        return OgdlSyntax.isGroup(ch, 20);
    }

    static int toLower(int ch) {
        return OgdlSyntax.isUpper(ch) ? ch + 32 : ch;
    }

    static int toUpper(int ch) {
        return OgdlSyntax.isLower(ch) ? ch - 32 : ch;
    }

    static int skip(CharSequence cs, int group, int index) {
        int i = index;
        while (i < cs.length()) {
            char ch = cs.charAt(i);
            if (!OgdlSyntax.isGroup(ch, group)) break;
            ++i;
        }
        return i;
    }

    static int skipExtendNameClass(CharSequence cs, int index) {
        int i = OgdlSyntax.skip(cs, 7340067, index);
        return OgdlSyntax.skip(cs, "[]", i);
    }

    static int skipMemberName(CharSequence cs, int index) {
        return OgdlSyntax.skip(cs, 1048611, index);
    }

    static int skipOperator(CharSequence cs, int index) {
        int i = OgdlSyntax.skip(cs, 10, index);
        if (cs.length() > i && OgdlSyntax.isSpace(cs, i)) {
            return i;
        }
        return index;
    }

    static int skipFunctionName(CharSequence cs, int index) {
        return OgdlSyntax.skip(cs, 9437219, index);
    }

    static int skipNumberString(CharSequence cs, int index) {
        int i = OgdlSyntax.skip(cs, 480, index);
        if (cs.length() > i && OgdlSyntax.isNumberSuffix(cs, i)) {
            ++i;
        }
        return i;
    }

    static int skipHexString(CharSequence cs, int index) {
        return OgdlSyntax.skip(cs, 64, index);
    }

    static int skipDateTimeString(CharSequence cs, int index) {
        return OgdlSyntax.skip(cs, 60817440, index);
    }

    static int skipEncloseString(OgdlEvent ev, CharSequence cs, int index) {
        int off = index;
        OgdlSyntax.validIndex(ev, cs, off);
        char close = OgdlSyntax.getEncloseCloseChar(cs, off);
        OgdlSyntax.validIndex(ev, cs, ++off);
        int length = cs.length();
        while (off < length) {
            if (-1 == (off = OgdlSyntax.indexOf(cs, off, close))) {
                throw new OgdlSyntaxException(ev, HLog.log("not find close char.", (Object)cs, close));
            }
            if (!OgdlSyntax.isCharAt(cs, off + 1, close)) break;
            ++off;
            ++off;
        }
        return ++off;
    }

    static String cutDifferenceString(String s, OgdlParseIndex index) {
        int start = index.get();
        int end = OgdlSyntax.skip((CharSequence)s, 17826275, start);
        index.set(end);
        return s.substring(start, end);
    }

    static String cutEncloseOrNumberString(OgdlEvent ev, String s, OgdlParseIndex index) {
        if (OgdlSyntax.isEncloseOpenChar(s, index.get())) {
            return OgdlSyntax.cutEncloseString(ev, s, index);
        }
        return OgdlSyntax.cutMemberName(s, index);
    }

    static String cutEncloseString(OgdlEvent ev, String s, OgdlParseIndex index) {
        int offset = index.get();
        OgdlSyntax.validIndex(ev, (CharSequence)s, offset);
        char close = OgdlSyntax.getEncloseCloseChar(s, offset);
        OgdlSyntax.validIndex(ev, (CharSequence)s, ++offset);
        StringBuffer buff = new StringBuffer(s.substring(offset));
        int off = 0;
        int delete = 0;
        while (off < buff.length()) {
            if (-1 == (off = OgdlSyntax.indexOf(buff, off, close))) {
                throw new OgdlSyntaxException(ev, HLog.log("not find close char.", (Object)s, close));
            }
            if (!OgdlSyntax.isCharAt(buff, off + 1, close)) break;
            ++delete;
            buff.deleteCharAt(off);
            ++off;
        }
        String value = buff.substring(0, off);
        int nextIndex = index.increment() + ++off + delete;
        index.set(nextIndex);
        return value;
    }

    static String cutExtendClassName(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipExtendNameClass(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static String cutMemberName(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipMemberName(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static String cutHexString(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipHexString(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static String cutDateTimeString(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipDateTimeString(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static String cutFunctionName(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipFunctionName(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static String cutNumberString(String s, OgdlParseIndex index) {
        int off = index.get();
        int nextIndex = OgdlSyntax.skipNumberString(s, off);
        String value = s.substring(off, nextIndex);
        index.set(nextIndex);
        return value;
    }

    static boolean isBeginClassName(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        return OgdlSyntax.isGroup(ch, 3);
    }

    static boolean isBeginMember(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        return OgdlSyntax.isGroup(ch, 0x100003);
    }

    static boolean isNumberSuffix(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        switch (ch) {
            case 'D': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'U': 
            case 'd': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'l': 
            case 's': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    static boolean isEncloseOpenChar(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        switch (ch) {
            case '!': 
            case '\"': 
            case '%': 
            case '\'': 
            case '(': 
            case '/': 
            case '<': 
            case '?': 
            case '@': 
            case '[': 
            case '`': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    static char getEncloseCloseChar(CharSequence cs, int index) {
        char ch = cs.charAt(index);
        switch (ch) {
            case '!': {
                return ch;
            }
            case '\"': {
                return ch;
            }
            case '%': {
                return ch;
            }
            case '\'': {
                return ch;
            }
            case '(': {
                return ')';
            }
            case '/': {
                return ch;
            }
            case '<': {
                return '>';
            }
            case '?': {
                return ch;
            }
            case '@': {
                return ch;
            }
            case '[': {
                return ']';
            }
            case '`': {
                return ch;
            }
            case '{': {
                return '}';
            }
            case '|': {
                return ch;
            }
        }
        return '\u0000';
    }

    static boolean isSpace(CharSequence cs, int index) {
        return cs.charAt(index) <= ' ';
    }

    static int nextSpace(CharSequence cs, int index) {
        return OgdlSyntax.skipNotSp(cs, index);
    }

    static int siftSpace(OgdlEvent ev) {
        ev.off.set(OgdlSyntax.skipSpace(ev, ev.ptn, ev.off.get()));
        return ev.off.get();
    }

    private static int skipSpace(OgdlEvent ev, CharSequence cs, int index) {
        int len = cs.length();
        int i = index;
        while (i < len) {
            if (!OgdlSyntax.isNotation(cs, i = OgdlSyntax.skipSp(cs, i))) break;
            ++i;
            i = OgdlSyntax.skipEncloseString(ev, cs, i);
        }
        return i;
    }

    private static boolean isNotation(CharSequence cs, int i) {
        return OgdlSyntax.isIndex(cs, i + 1) && 'N' == cs.charAt(i) && OgdlSyntax.isEncloseOpenChar(cs, i + 1);
    }

    private static int skipNotSp(CharSequence cs, int fromIndex) {
        int i = fromIndex;
        while (i < cs.length()) {
            if (cs.charAt(i) <= ' ') break;
            ++i;
        }
        return i;
    }

    private static int skipSp(CharSequence cs, int fromIndex) {
        int i = fromIndex;
        int length = cs.length();
        while (i < length) {
            if (cs.charAt(i) > ' ') break;
            ++i;
        }
        return i;
    }

    static boolean isArraylength(Class clazz, String memberName) {
        return clazz.isArray() && "length".equals(memberName);
    }

    static boolean isClose(CharSequence cs, OgdlParseIndex off, char close) {
        return OgdlSyntax.isCharAt(cs, off.get(), close);
    }

    static boolean isNotClose(CharSequence cs, OgdlParseIndex off, char close) {
        return !OgdlSyntax.isCharAt(cs, off.get(), close);
    }

    static boolean isNotSeparator(CharSequence cs, int off) {
        return !OgdlSyntax.isCharAt(cs, off, ',');
    }

    static boolean isNotMapSeparator(CharSequence cs, OgdlParseIndex off) {
        return !OgdlSyntax.isCharAt(cs, off.get(), '=');
    }

    static void validIndex(OgdlEvent ev, CharSequence cs, OgdlParseIndex off) {
        if (!OgdlSyntax.isIndex(cs, off)) {
            throw new OgdlSyntaxException(ev, HLog.log("index err.", (Object)cs, off));
        }
    }

    static void validIndex(OgdlEvent ev, CharSequence cs, int index) {
        if (!OgdlSyntax.isIndex(cs, index)) {
            throw new OgdlSyntaxException(ev, HLog.log("index err.", (Object)cs, index));
        }
    }

    static boolean isIndex(CharSequence cs, OgdlParseIndex off) {
        return OgdlSyntax.isIndex(cs, off.get());
    }

    private static boolean isIndex(CharSequence cs, int index) {
        return index >= 0 && index < cs.length();
    }

    static boolean isCharAt(OgdlEvent ev, char c) {
        return OgdlSyntax.isCharAt(ev.ptn, ev.off.get(), c);
    }

    static boolean isCharAt(CharSequence cs, int index, char c) {
        return OgdlSyntax.isIndex(cs, index) && cs.charAt(index) == c;
    }

    private static int skip(CharSequence cs, CharSequence chars, int fromIndex) {
        int charslen = chars.length();
        int i = fromIndex;
        while (i < cs.length()) {
            if (!HEval.isStartsWith(cs, chars, i)) break;
            i += charslen;
        }
        return i;
    }

    private static int indexOf(CharSequence cs, int fromIndex, char searchChar) {
        int i = fromIndex;
        while (i < cs.length()) {
            if (cs.charAt(i) == searchChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

