/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.HClass;
import shohaku.ogdl.HEval;
import shohaku.ogdl.HLog;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlPrimitiveParser {
    OgdlPrimitiveParser() {
    }

    static String evaluateString(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            return OgdlPrimitiveParser.evaluateEncloseString(ev);
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static String evaluateEncloseString(OgdlEvent ev) throws OgdlSyntaxException {
        return OgdlSyntax.cutEncloseString(ev, ev.ptn, ev.off);
    }

    static Character evaluateCharacter(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            String src = OgdlSyntax.cutEncloseString(ev, ev.ptn, ev.off);
            return Boxing.box(OgdlPrimitiveParser.decodeCharacter(ev, src));
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Object evaluateReference(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            String s = OgdlSyntax.cutEncloseString(ev, ev.ptn, ev.off);
            return ev.context.getAttribute(s);
        }
        String s = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
        return ev.context.getAttribute(s);
    }

    static Date evaluateDateTime(OgdlEvent ev) throws OgdlSyntaxException {
        if (!OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            throw new OgdlSyntaxException(ev, "is not enclose literal.");
        }
        String s = OgdlSyntax.cutEncloseString(ev, ev.ptn, ev.off);
        Date date = OgdlPrimitiveParser.toDateTime(s);
        if (date == null) {
            throw new OgdlSyntaxException(ev, HLog.log("date time format err.", s));
        }
        return date;
    }

    static Pattern evaluateRegexPattern(OgdlEvent ev) throws OgdlSyntaxException {
        if (!OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            throw new OgdlSyntaxException(ev, "is not enclose literal.");
        }
        String s = OgdlSyntax.cutEncloseString(ev, ev.ptn, ev.off);
        try {
            return Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            throw new OgdlSyntaxException(ev, HLog.log("regex pattern err.", s), e);
        }
    }

    static Number evaluateNumber(OgdlEvent ev) {
        return OgdlPrimitiveParser.toNumber(ev, OgdlSyntax.cutNumberString(ev.ptn, ev.off));
    }

    static Integer evaluateInteger(OgdlEvent ev) throws OgdlSyntaxException {
        return Boxing.box(OgdlPrimitiveParser.toNumber(ev, OgdlSyntax.cutNumberString(ev.ptn, ev.off)).intValue());
    }

    static Number evaluateInfinity(OgdlEvent ev) {
        return OgdlPrimitiveParser.toInfinity(ev.ptn);
    }

    static Number evaluateNaN(OgdlEvent ev) {
        return OgdlPrimitiveParser.toNaN(ev.ptn);
    }

    static Class evaluateClassByExtendName(OgdlEvent ev) {
        return OgdlPrimitiveParser.loadClassByExtendClassName(ev, OgdlSyntax.cutExtendClassName(ev.ptn, ev.off));
    }

    private static Date toDateTime(String s) {
        SimpleDateFormat format = new SimpleDateFormat();
        format.setLenient(false);
        switch (s.length()) {
            case 2: {
                format.applyPattern("HH");
                break;
            }
            case 4: {
                format.applyPattern("yyyy");
                break;
            }
            case 5: {
                format.applyPattern("HH:mm");
                break;
            }
            case 7: {
                format.applyPattern("yyyy-MM");
                break;
            }
            case 8: {
                format.applyPattern("HH:mm:ss");
                break;
            }
            case 10: {
                format.applyPattern("yyyy-MM-dd");
                break;
            }
            case 12: {
                format.applyPattern("HH:mm:ss.SSS");
                break;
            }
            case 13: {
                format.applyPattern("yyyy-MM-dd HH");
                break;
            }
            case 16: {
                format.applyPattern("yyyy-MM-dd HH:mm");
                break;
            }
            case 19: {
                format.applyPattern("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 23: {
                format.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                break;
            }
            default: {
                return null;
            }
        }
        return format.parse(s, new ParsePosition(0));
    }

    private static char decodeCharacter(OgdlEvent ev, CharSequence src) {
        if (HEval.isEmpty(src)) {
            throw new OgdlSyntaxException(ev, HLog.log("Malformed character encoding.", src));
        }
        char c = src.charAt(0);
        if (c == '\\') {
            if (src.length() < 2) {
                throw new OgdlSyntaxException(ev, HLog.log("Malformed character encoding.", src));
            }
            c = src.charAt(1);
            if (c == 'u') {
                if (src.length() != 6) {
                    throw new OgdlSyntaxException(ev, HLog.log("Malformed \\uxxxx encoding.", src));
                }
                return OgdlPrimitiveParser.decodeHexCharacter(ev, src, 2);
            }
            if (src.length() != 2) {
                throw new OgdlSyntaxException(ev, HLog.log("Malformed \\x encoding.", src));
            }
            return OgdlPrimitiveParser.decodeCntrlCharacter(ev, src, c);
        }
        if (src.length() != 1) {
            throw new OgdlSyntaxException(ev, HLog.log("Malformed 'x' encoding.", src));
        }
        return c;
    }

    private static char decodeCntrlCharacter(OgdlEvent ev, CharSequence src, char c) {
        switch (c) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
        }
        throw new OgdlSyntaxException(ev, HLog.log("Malformed \\x encoding.", src));
    }

    private static char decodeHexCharacter(OgdlEvent ev, CharSequence src, int index) {
        int value = 0;
        int i = index;
        while (i < index + 4) {
            char c = src.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + c - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + 10 + c - 97;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + 10 + c - 65;
                    break;
                }
                default: {
                    throw new OgdlSyntaxException(ev, HLog.log("Malformed \\uxxxx encoding.", src));
                }
            }
            ++i;
        }
        return (char)value;
    }

    private static Number toNumber(OgdlEvent ev, String s) throws OgdlSyntaxException {
        try {
            Number num;
            int suffix = OgdlSyntax.toUpper(s.charAt(s.length() - 1));
            String snum = s.substring(0, s.length() - 1);
            switch (suffix) {
                case 68: {
                    num = Double.valueOf(snum);
                    break;
                }
                case 70: {
                    num = Float.valueOf(snum);
                    break;
                }
                case 71: {
                    num = new BigDecimal(snum);
                    break;
                }
                case 72: {
                    num = new BigInteger(snum);
                    break;
                }
                case 73: {
                    num = Integer.decode(snum);
                    break;
                }
                case 76: {
                    num = Long.decode(snum);
                    break;
                }
                case 83: {
                    num = Short.decode(snum);
                    break;
                }
                case 85: {
                    num = Byte.decode(snum);
                    break;
                }
                default: {
                    num = HEval.isContains(s, '.') ? (Number)Double.valueOf(s) : (Number)Integer.decode(s);
                }
            }
            return num;
        }
        catch (NumberFormatException e) {
            throw new OgdlSyntaxException(ev, HLog.log("value is not Number format. ", s), e);
        }
    }

    private static Number toInfinity(String s) throws OgdlSyntaxException {
        int suffix = OgdlSyntax.toUpper(s.charAt(s.length() - 1));
        switch (suffix) {
            case 68: {
                return Boxing.box(Double.POSITIVE_INFINITY);
            }
            case 70: {
                return Boxing.box(Float.POSITIVE_INFINITY);
            }
        }
        return Boxing.box(Double.POSITIVE_INFINITY);
    }

    private static Number toNaN(String s) throws OgdlSyntaxException {
        int suffix = OgdlSyntax.toUpper(s.charAt(s.length() - 1));
        switch (suffix) {
            case 68: {
                return Boxing.box(Double.NaN);
            }
            case 70: {
                return Boxing.box(Float.NaN);
            }
        }
        return Boxing.box(Double.NaN);
    }

    private static Class loadClassByExtendClassName(OgdlEvent ev, String extendClassName) {
        StringBuffer symbol = new StringBuffer();
        int off = extendClassName.length();
        while (off >= 2 && extendClassName.charAt(off - 1) == ']' && extendClassName.charAt(off - 2) == '[') {
            off -= 2;
            symbol.append('[');
        }
        boolean isArray = symbol.length() > 0;
        String rootName = isArray ? extendClassName.substring(0, off) : extendClassName;
        Class clazz = OgdlPrimitiveParser.findClass(rootName, ev);
        if (isArray) {
            StringBuffer className = new StringBuffer();
            if (clazz != null) {
                String primitiveName = (String)HClass.PRIMITIVE_CLASS_NAME_MAP.get(clazz);
                if (primitiveName == null) {
                    className.append(symbol).append('L').append(clazz.getName()).append(';');
                } else {
                    className.append(symbol).append(primitiveName);
                }
            } else {
                className.append(symbol).append('L').append(rootName).append(';');
            }
            Class loadClass = HClass.loadClass(className.toString(), ev.loader);
            if (loadClass != null) {
                return loadClass;
            }
        } else {
            if (clazz != null) {
                return clazz;
            }
            Class loadClass = HClass.loadClass(rootName, ev.loader);
            if (loadClass != null) {
                return loadClass;
            }
        }
        throw new OgdlSyntaxException(ev, HLog.log("not find class. ", extendClassName));
    }

    private static Class findClass(String className, OgdlEvent ev) {
        Class<?> clazz = (Class<?>)HClass.PRIMITIVE_FOR_TYPE_MAP.get(className);
        if (clazz == null && !HEval.isContains(className, '.')) {
            try {
                clazz = Class.forName("java.lang." + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = ev.context.forImport(className);
        }
        return clazz;
    }
}

