/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import shohaku.ogdl.OgdlCollectionParser;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlFunctionParser;
import shohaku.ogdl.OgdlIntrospectParser;
import shohaku.ogdl.OgdlOperatorParser;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;
import shohaku.ogdl.OgdlUnaryOperatorParser;

class OgdlParser {
    OgdlParser() {
    }

    static Object evaluateExpression(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char open = ptn.charAt(off.get());
        int begin = off.get();
        switch (open) {
            case '!': {
                return OgdlUnaryOperatorParser.evaluateLogicalComplement(ev);
            }
            case '%': {
                return OgdlPrimitiveParser.evaluateRegexPattern(ev);
            }
            case '\'': {
                return OgdlPrimitiveParser.evaluateEncloseString(ev);
            }
            case '(': {
                return OgdlOperatorParser.evaluateEncloseOperator(ev);
            }
            case '-': {
                return OgdlUnaryOperatorParser.evaluateUnaryMinus(ev);
            }
            case '/': {
                return OgdlPrimitiveParser.evaluateDateTime(ev);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return OgdlPrimitiveParser.evaluateNumber(ev);
            }
            case '<': {
                return OgdlCollectionParser.evaluateDefaultSet(ev);
            }
            case '@': {
                if (OgdlParser.isLiteral(ev, "@@", ptn, begin)) {
                    return OgdlPrimitiveParser.evaluateClassByExtendName(ev);
                }
                ev.off.increment();
                return OgdlPrimitiveParser.evaluateReference(ev);
            }
            case 'D': {
                ev.off.increment();
                return OgdlPrimitiveParser.evaluateDateTime(ev);
            }
            case 'F': {
                ev.off.increment();
                return OgdlOperatorParser.evaluateOperator(ev);
            }
            case 'I': {
                if (!OgdlParser.isLiteral(ev, "Infinity", ptn, begin)) break;
                return OgdlPrimitiveParser.evaluateInfinity(ev);
            }
            case 'N': {
                if (!OgdlParser.isLiteral(ev, "NaN", ptn, begin)) break;
                return OgdlPrimitiveParser.evaluateNaN(ev);
            }
            case 'R': {
                ev.off.increment();
                return OgdlPrimitiveParser.evaluateRegexPattern(ev);
            }
            case 'S': {
                ev.off.increment();
                return OgdlPrimitiveParser.evaluateString(ev);
            }
            case 'U': {
                ev.off.increment();
                return OgdlPrimitiveParser.evaluateCharacter(ev);
            }
            case '[': {
                return OgdlCollectionParser.evaluateDefaultList(ev);
            }
            case '`': {
                return OgdlPrimitiveParser.evaluateCharacter(ev);
            }
            case 'a': {
                if (!OgdlParser.isPrefixName(ev, "array:", ptn, begin)) break;
                return OgdlCollectionParser.evaluateArray(ev);
            }
            case 'c': {
                if (OgdlParser.isPrefixName(ev, "class:", ptn, begin)) {
                    return OgdlPrimitiveParser.evaluateClassByExtendName(ev);
                }
                if (OgdlParser.isPrefixName(ev, "coll:", ptn, begin)) {
                    return OgdlCollectionParser.evaluateCollection(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "cons:", ptn, begin)) break;
                return OgdlIntrospectParser.evaluateConstructor(ev);
            }
            case 'f': {
                if (OgdlParser.isLiteral(ev, "false", ptn, begin)) {
                    return Boolean.FALSE;
                }
                if (OgdlParser.isPrefixName(ev, "field:", ptn, begin)) {
                    return OgdlIntrospectParser.evaluateField(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "f:", ptn, begin)) break;
                return OgdlFunctionParser.evaluateFunction(ev);
            }
            case 'l': {
                if (!OgdlParser.isPrefixName(ev, "list:", ptn, begin)) break;
                return OgdlCollectionParser.evaluateList(ev);
            }
            case 'm': {
                if (OgdlParser.isPrefixName(ev, "map:", ptn, begin)) {
                    return OgdlCollectionParser.evaluateMap(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "method:", ptn, begin)) break;
                return OgdlIntrospectParser.evaluateMethod(ev);
            }
            case 'n': {
                if (OgdlParser.isLiteral(ev, "null", ptn, begin)) {
                    return null;
                }
                if (!OgdlParser.isPrefixName(ev, "new:", ptn, begin)) break;
                return OgdlIntrospectParser.evaluateNewInstance(ev);
            }
            case 'r': {
                if (!OgdlParser.isPrefixName(ev, "ref:", ptn, begin)) break;
                return OgdlPrimitiveParser.evaluateReference(ev);
            }
            case 's': {
                if (OgdlParser.isPrefixName(ev, "set:", ptn, begin)) {
                    return OgdlCollectionParser.evaluateSet(ev);
                }
                if (OgdlParser.isPrefixName(ev, "sortedSet:", ptn, begin)) {
                    return OgdlCollectionParser.evaluateSortedSet(ev);
                }
                if (!OgdlParser.isPrefixName(ev, "sortedMap:", ptn, begin)) break;
                return OgdlCollectionParser.evaluateSortedMap(ev);
            }
            case 't': {
                if (!OgdlParser.isLiteral(ev, "true", ptn, begin)) break;
                return Boolean.TRUE;
            }
            case '{': {
                return OgdlCollectionParser.evaluateDefaultMap(ev);
            }
            case '~': {
                return OgdlUnaryOperatorParser.evaluateBitwiseComplement(ev);
            }
        }
        throw new OgdlSyntaxException(ev, "not found expression.");
    }

    static Collection evaluateEncloseCollection(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateEncloseCollection(ev);
    }

    static Collection evaluateCloseCollection(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateCloseCollection(ev);
    }

    static Map evaluateEncloseMap(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateEncloseMap(ev);
    }

    static Map evaluateCloseMap(OgdlEvent ev) {
        return OgdlCollectionParser.evaluateCloseMap(ev);
    }

    static List evaluateEncloseProgressionList(OgdlEvent ev) {
        return (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev);
    }

    static List evaluateCloseProgressionList(OgdlEvent ev) {
        return (List)OgdlCollectionParser.evaluateCloseProgressionCollection(ev);
    }

    static Object evaluatePostfixExpression(OgdlEvent ev, Object returnValue) {
        char open = ev.ptn.charAt(ev.off.get());
        switch (open) {
            case '#': 
            case '.': 
            case '[': {
                ev.target = returnValue;
                return OgdlIntrospectParser.evaluateObjectNavigate(ev);
            }
        }
        return returnValue;
    }

    private static boolean isLiteral(OgdlEvent ev, String literal, String ptn, int begin) {
        if (ptn.startsWith(literal, begin)) {
            ev.off.add(literal.length());
            return true;
        }
        return false;
    }

    private static boolean isPrefixName(OgdlEvent ev, String id, String ptn, int begin) {
        if (ptn.startsWith(id, begin)) {
            ev.off.add(id.length());
            OgdlSyntax.siftSpace(ev);
            if (ev.off.get() >= ev.ptn.length()) {
                throw new OgdlSyntaxException(ev, "offset err.");
            }
            return true;
        }
        return false;
    }
}

