/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlFunctionException;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlOperatorParser {
    OgdlOperatorParser() {
    }

    static Object evaluateOperator(OgdlEvent ev) {
        if (OgdlSyntax.isEncloseOpenChar(ev.ptn, ev.off.get())) {
            return OgdlOperatorParser.evaluateEncloseOperator(ev);
        }
        throw new OgdlSyntaxException(ev, "is not enclose literal.");
    }

    static Object evaluateEncloseOperator(OgdlEvent ev) {
        int size;
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char close = OgdlSyntax.getEncloseCloseChar(ptn, off.get());
        off.increment();
        int begin = off.get();
        int next = OgdlSyntax.skipOperator(ptn, begin);
        if (next == begin || next - begin > 4) {
            return OgdlOperatorParser.evaluateExpressionGroup(ev, close);
        }
        String name = ptn.substring(begin, next);
        int type = OgdlOperatorParser.asOperatorType(name, size = next - begin);
        if (-1 == type) {
            return OgdlOperatorParser.evaluateExpressionGroup(ev, close);
        }
        off.set(next);
        List args = OgdlOperatorParser.getArguments(ev, close);
        try {
            if (args.isEmpty()) {
                throw new OgdlFunctionException(ev, "empty arguments. ");
            }
            if (type >= 0 && type <= 7) {
                return OgdlOperatorParser.evaluateArithmeticOperator(ev, type, args);
            }
            if (8 <= type && type <= 10) {
                return OgdlOperatorParser.evaluateShiftOperator(ev, type, args);
            }
            if (11 <= type && type <= 16) {
                return OgdlOperatorParser.evaluateRelationalOperator(ev, type, args);
            }
            if (20 <= type) {
                return OgdlOperatorParser.evaluateObjectOperator(ev, type, args);
            }
            throw new OgdlFunctionException(ev, "illegal operator type. ");
        }
        catch (OgdlFunctionException e) {
            throw e.throwFor(ev, name, args);
        }
        catch (RuntimeException e) {
            OgdlFunctionException fe = new OgdlFunctionException("java runtime err.", e);
            throw fe.throwFor(ev, name, args);
        }
    }

    private static Object evaluateArithmeticOperator(OgdlEvent ev, int type, List args) {
        Object t;
        if (2 > args.size()) {
            throw new OgdlFunctionException(ev, "illegal arguments size. 2 > size. ");
        }
        Object f = args.get(0);
        if (OgdlOperatorParser.isNumberOperand(f, t = args.get(1))) {
            return OgdlOperatorParser.evaluateArithmeticNumberOperator(ev, type, args);
        }
        if (OgdlOperatorParser.isBooleanOperand(f, t)) {
            return OgdlOperatorParser.evaluateArithmeticBooleanOperator(ev, type, args);
        }
        if (OgdlOperatorParser.isStringOperand(f, t)) {
            return OgdlOperatorParser.evaluateArithmeticStringOperator(ev, type, args);
        }
        throw new OgdlFunctionException(ev, "illegal operand type. ");
    }

    private static Object evaluateShiftOperator(OgdlEvent ev, int type, List args) {
        Object t;
        if (2 > args.size()) {
            throw new OgdlFunctionException(ev, "illegal arguments size. 2 > size. ");
        }
        Object f = args.get(0);
        if (OgdlOperatorParser.isNumberOperand(f, t = args.get(1))) {
            return OgdlOperatorParser.evaluateShiftNumberOperator(ev, type, args);
        }
        throw new OgdlFunctionException(ev, "illegal operand type. ");
    }

    private static Object evaluateRelationalOperator(OgdlEvent ev, int type, List args) {
        Object t;
        if (2 > args.size()) {
            throw new OgdlFunctionException(ev, "illegal arguments size. 2 > size. ");
        }
        Object f = args.get(0);
        if (OgdlOperatorParser.isNumberOperand(f, t = args.get(1))) {
            return OgdlOperatorParser.evaluateRelationalNumberOperator(ev, type, args);
        }
        if (OgdlOperatorParser.isComparableOperand(f, t)) {
            return OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, args);
        }
        throw new OgdlFunctionException(ev, "illegal operand type. ");
    }

    private static Object evaluateObjectOperator(OgdlEvent ev, int type, List args) {
        switch (type) {
            case 20: {
                return OgdlOperatorParser.evaluateInstanceOfOperator(ev, args);
            }
            case 21: {
                return OgdlOperatorParser.evaluateEqualsOperator(args);
            }
            case 22: {
                return OgdlOperatorParser.evaluateNotEqualsOperator(args);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Object evaluateArithmeticNumberOperator(OgdlEvent ev, int type, List args) {
        try {
            Iterator i = args.iterator();
            Number f = OgdlOperatorParser.toNumber(i.next());
            Number t = null;
            while (i.hasNext()) {
                Number bt;
                Number bf;
                t = OgdlOperatorParser.toNumber(i.next());
                if (OgdlOperatorParser.isBigDecimalOperand(f, t)) {
                    bf = OgdlOperatorParser.toBigDecimal(f);
                    bt = OgdlOperatorParser.toBigDecimal(t);
                    f = OgdlOperatorParser.evaluateArithmeticBigDecimalOperator(ev, type, bf, bt);
                    continue;
                }
                if (f instanceof BigInteger || t instanceof BigInteger) {
                    bf = OgdlOperatorParser.toBigInteger(f);
                    bt = OgdlOperatorParser.toBigInteger(t);
                    f = OgdlOperatorParser.evaluateArithmeticBigIntegerOperator(ev, type, (BigInteger)bf, (BigInteger)bt);
                    continue;
                }
                if (f instanceof Double || t instanceof Double) {
                    f = OgdlOperatorParser.evaluateArithmeticDoubleOperator(ev, type, f.doubleValue(), t.doubleValue());
                    continue;
                }
                if (f instanceof Float || t instanceof Float) {
                    f = OgdlOperatorParser.evaluateArithmeticFloatOperator(ev, type, f.floatValue(), t.floatValue());
                    continue;
                }
                if (f instanceof Long || t instanceof Long) {
                    f = OgdlOperatorParser.evaluateArithmeticLongOperator(ev, type, f.longValue(), t.longValue());
                    continue;
                }
                if (OgdlOperatorParser.isIntegerOperand(f, t)) {
                    f = OgdlOperatorParser.evaluateArithmeticIntegerOperator(ev, type, f.intValue(), t.intValue());
                    continue;
                }
                throw new OgdlFunctionException(ev, "illegal operand type. ");
            }
            return f;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args is not Number. ", e);
        }
        catch (NumberFormatException e) {
            throw new OgdlFunctionException(ev, "args is infinite or NaN. ", e);
        }
        catch (ArithmeticException e) {
            throw new OgdlFunctionException(ev, "arithmetic err. ", e);
        }
    }

    private static boolean isBigDecimalOperand(Number f, Number t) {
        if (f instanceof BigDecimal || t instanceof BigDecimal) {
            return true;
        }
        if (f instanceof BigInteger && (t instanceof Double || t instanceof Float)) {
            return true;
        }
        return t instanceof BigInteger && (f instanceof Double || f instanceof Float);
    }

    private static Object evaluateArithmeticBooleanOperator(OgdlEvent ev, int type, List args) {
        try {
            Iterator i = args.iterator();
            Boolean f = (Boolean)i.next();
            Boolean t = null;
            Iterator j = i;
            while (j.hasNext()) {
                t = (Boolean)j.next();
                f = OgdlOperatorParser.evaluateArithmeticBooleanOperator(ev, type, f, t);
            }
            return f;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args is not Boolean. ", e);
        }
    }

    private static Object evaluateArithmeticStringOperator(OgdlEvent ev, int type, List args) {
        switch (type) {
            case 0: {
                return OgdlOperatorParser.evaluateStringConcatenationOperator(args);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Integer evaluateArithmeticIntegerOperator(OgdlEvent ev, int type, int from, int to) {
        switch (type) {
            case 0: {
                return Boxing.box(from + to);
            }
            case 1: {
                return Boxing.box(from - to);
            }
            case 2: {
                return Boxing.box(from * to);
            }
            case 3: {
                return Boxing.box(from / to);
            }
            case 4: {
                return Boxing.box(from % to);
            }
            case 5: {
                return Boxing.box(from & to);
            }
            case 6: {
                return Boxing.box(from ^ to);
            }
            case 7: {
                return Boxing.box(from | to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Long evaluateArithmeticLongOperator(OgdlEvent ev, int type, long from, long to) {
        switch (type) {
            case 0: {
                return Boxing.box(from + to);
            }
            case 1: {
                return Boxing.box(from - to);
            }
            case 2: {
                return Boxing.box(from * to);
            }
            case 3: {
                return Boxing.box(from / to);
            }
            case 4: {
                return Boxing.box(from % to);
            }
            case 5: {
                return Boxing.box(from & to);
            }
            case 6: {
                return Boxing.box(from ^ to);
            }
            case 7: {
                return Boxing.box(from | to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Float evaluateArithmeticFloatOperator(OgdlEvent ev, int type, float from, float to) {
        switch (type) {
            case 0: {
                return Boxing.box(from + to);
            }
            case 1: {
                return Boxing.box(from - to);
            }
            case 2: {
                return Boxing.box(from * to);
            }
            case 3: {
                return Boxing.box(from / to);
            }
            case 4: {
                return Boxing.box(from % to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Double evaluateArithmeticDoubleOperator(OgdlEvent ev, int type, double from, double to) {
        switch (type) {
            case 0: {
                return Boxing.box(from + to);
            }
            case 1: {
                return Boxing.box(from - to);
            }
            case 2: {
                return Boxing.box(from * to);
            }
            case 3: {
                return Boxing.box(from / to);
            }
            case 4: {
                return Boxing.box(from % to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static BigInteger evaluateArithmeticBigIntegerOperator(OgdlEvent ev, int type, BigInteger from, BigInteger to) {
        switch (type) {
            case 0: {
                return from.add(to);
            }
            case 1: {
                return from.subtract(to);
            }
            case 2: {
                return from.multiply(to);
            }
            case 3: {
                return from.divide(to);
            }
            case 4: {
                return from.remainder(to);
            }
            case 5: {
                return from.and(to);
            }
            case 6: {
                return from.xor(to);
            }
            case 7: {
                return from.or(to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static BigDecimal evaluateArithmeticBigDecimalOperator(OgdlEvent ev, int type, BigDecimal from, BigDecimal to) {
        switch (type) {
            case 0: {
                return from.add(to);
            }
            case 1: {
                return from.subtract(to);
            }
            case 2: {
                return from.multiply(to);
            }
            case 3: {
                return from.divide(to, 6);
            }
            case 4: {
                return from.subtract(new BigDecimal(from.divide(to, 1).toBigInteger()).multiply(to));
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Boolean evaluateArithmeticBooleanOperator(OgdlEvent ev, int type, boolean from, boolean to) {
        switch (type) {
            case 5: {
                return Boxing.box(from & to);
            }
            case 6: {
                return Boxing.box(from ^ to);
            }
            case 7: {
                return Boxing.box(from | to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Object evaluateShiftNumberOperator(OgdlEvent ev, int type, List args) {
        try {
            Iterator i = args.iterator();
            Number f = OgdlOperatorParser.toNumber(i.next());
            Number t = null;
            while (i.hasNext()) {
                t = OgdlOperatorParser.toNumber(i.next());
                if (f instanceof BigDecimal || t instanceof BigDecimal) {
                    throw new OgdlFunctionException(ev, "illegal operand type. ");
                }
                if (f instanceof Double || t instanceof Double) {
                    throw new OgdlFunctionException(ev, "illegal operand type. ");
                }
                if (f instanceof Float || t instanceof Float) {
                    throw new OgdlFunctionException(ev, "illegal operand type. ");
                }
                if (f instanceof BigInteger && OgdlOperatorParser.isIntegerOperand(t)) {
                    f = OgdlOperatorParser.evaluateShiftBigIntegerIntOperator(ev, type, (BigInteger)f, t.intValue());
                    continue;
                }
                if (f instanceof Long && t instanceof Long) {
                    f = OgdlOperatorParser.evaluateShiftLongLongOperator(ev, type, f.longValue(), t.longValue());
                    continue;
                }
                if (OgdlOperatorParser.isIntegerOperand(f) && t instanceof Long) {
                    f = OgdlOperatorParser.evaluateShiftIntegerLongOperator(ev, type, f.intValue(), t.longValue());
                    continue;
                }
                if (f instanceof Long && OgdlOperatorParser.isIntegerOperand(t)) {
                    f = OgdlOperatorParser.evaluateShiftLongIntegerOperator(ev, type, f.longValue(), t.intValue());
                    continue;
                }
                if (OgdlOperatorParser.isIntegerOperand(f, t)) {
                    f = OgdlOperatorParser.evaluateShiftIntegerIntegerOperator(ev, type, f.intValue(), t.intValue());
                    continue;
                }
                throw new OgdlFunctionException(ev, "illegal operand type. ");
            }
            return f;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args is not Number. ", e);
        }
    }

    private static Integer evaluateShiftIntegerIntegerOperator(OgdlEvent ev, int type, int from, int to) {
        switch (type) {
            case 8: {
                return Boxing.box(from << to);
            }
            case 9: {
                return Boxing.box(from >> to);
            }
            case 10: {
                return Boxing.box(from >>> to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Integer evaluateShiftIntegerLongOperator(OgdlEvent ev, int type, int from, long to) {
        switch (type) {
            case 8: {
                return Boxing.box(from << (int)to);
            }
            case 9: {
                return Boxing.box(from >> (int)to);
            }
            case 10: {
                return Boxing.box(from >>> (int)to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Long evaluateShiftLongIntegerOperator(OgdlEvent ev, int type, long from, int to) {
        switch (type) {
            case 8: {
                return Boxing.box(from << to);
            }
            case 9: {
                return Boxing.box(from >> to);
            }
            case 10: {
                return Boxing.box(from >>> to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Long evaluateShiftLongLongOperator(OgdlEvent ev, int type, long from, long to) {
        switch (type) {
            case 8: {
                return Boxing.box(from << (int)to);
            }
            case 9: {
                return Boxing.box(from >> (int)to);
            }
            case 10: {
                return Boxing.box(from >>> (int)to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static BigInteger evaluateShiftBigIntegerIntOperator(OgdlEvent ev, int type, BigInteger from, int to) {
        switch (type) {
            case 8: {
                return from.shiftLeft(to);
            }
            case 9: {
                return from.shiftRight(to);
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Boolean evaluateRelationalNumberOperator(OgdlEvent ev, int type, List args) {
        try {
            Iterator i = args.iterator();
            Number f = OgdlOperatorParser.toNumber(i.next());
            Number t = null;
            Iterator j = i;
            while (j.hasNext()) {
                Number bt;
                Number bf;
                t = OgdlOperatorParser.toNumber(j.next());
                if (OgdlOperatorParser.isBigDecimalOperand(f, t)) {
                    bf = OgdlOperatorParser.toBigDecimal(f);
                    if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, bf, bt = OgdlOperatorParser.toBigDecimal(t))) continue;
                    return Boolean.FALSE;
                }
                if (f instanceof BigInteger || t instanceof BigInteger) {
                    bf = OgdlOperatorParser.toBigInteger(f);
                    if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, bf, bt = OgdlOperatorParser.toBigInteger(t))) continue;
                    return Boolean.FALSE;
                }
                if (f instanceof Double || t instanceof Double) {
                    if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, Boxing.box(f.doubleValue()), Boxing.box(t.doubleValue()))) continue;
                    return Boolean.FALSE;
                }
                if (f instanceof Float || t instanceof Float) {
                    if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, Boxing.box(f.floatValue()), Boxing.box(t.floatValue()))) continue;
                    return Boolean.FALSE;
                }
                if (f instanceof Long || t instanceof Long) {
                    if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, Boxing.box(f.longValue()), Boxing.box(t.longValue()))) continue;
                    return Boolean.FALSE;
                }
                if (OgdlOperatorParser.isIntegerOperand(f, t)) {
                    if (!OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, Boxing.box(f.intValue()), Boxing.box(t.intValue()))) continue;
                    return Boolean.FALSE;
                }
                throw new OgdlFunctionException(ev, "illegal operand type. ");
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args is not Number. ", e);
        }
        catch (NumberFormatException e) {
            throw new OgdlFunctionException(ev, "args is infinite or NaN. ", e);
        }
    }

    private static Boolean evaluateRelationalComparableOperator(OgdlEvent ev, int type, List args) {
        try {
            Iterator i = args.iterator();
            Comparable f = (Comparable)i.next();
            Comparable t = null;
            Iterator j = i;
            while (j.hasNext()) {
                t = (Comparable)j.next();
                if (OgdlOperatorParser.evaluateRelationalComparableOperator(ev, type, f, t)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args is not Comparable. ", e);
        }
    }

    private static boolean evaluateRelationalComparableOperator(OgdlEvent ev, int type, Comparable from, Comparable to) {
        switch (type) {
            case 11: {
                return from.compareTo(to) == 0;
            }
            case 12: {
                return from.compareTo(to) != 0;
            }
            case 13: {
                return from.compareTo(to) < 0;
            }
            case 14: {
                return from.compareTo(to) <= 0;
            }
            case 15: {
                return from.compareTo(to) > 0;
            }
            case 16: {
                return from.compareTo(to) >= 0;
            }
        }
        throw new OgdlFunctionException(ev, "illegal operator type. ");
    }

    private static Boolean evaluateInstanceOfOperator(OgdlEvent ev, List args) {
        try {
            Iterator i = args.iterator();
            Object e = i.next();
            while (i.hasNext()) {
                if (((Class)i.next()).isInstance(e)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (ClassCastException e) {
            throw new OgdlFunctionException(ev, "args[1 < n] is not Class. ", e);
        }
    }

    private static Boolean evaluateNotEqualsOperator(List args) {
        Iterator i = args.iterator();
        Object e = i.next();
        while (i.hasNext()) {
            if (!OgdlOperatorParser.eqs(e, i.next())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean evaluateEqualsOperator(List args) {
        Iterator i = args.iterator();
        Object e = i.next();
        while (i.hasNext()) {
            if (OgdlOperatorParser.eqs(e, i.next())) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static boolean eqs(Object e, Object e2) {
        return e == e2 || e != null && e.equals(e2);
    }

    private static String evaluateStringConcatenationOperator(List args) {
        StringBuffer buff = new StringBuffer();
        Iterator i = args.iterator();
        while (i.hasNext()) {
            buff.append(i.next());
        }
        return buff.toString();
    }

    private static int asOperatorType(String name, int size) {
        int type = -1;
        block0 : switch (size) {
            case 1: {
                char c = name.charAt(0);
                switch (c) {
                    case '%': {
                        type = 4;
                        break block0;
                    }
                    case '&': {
                        type = 5;
                        break block0;
                    }
                    case '*': {
                        type = 2;
                        break block0;
                    }
                    case '+': {
                        type = 0;
                        break block0;
                    }
                    case '-': {
                        type = 1;
                        break block0;
                    }
                    case '/': {
                        type = 3;
                        break block0;
                    }
                    case '<': {
                        type = 13;
                        break block0;
                    }
                    case '>': {
                        type = 15;
                        break block0;
                    }
                    case '^': {
                        type = 6;
                        break block0;
                    }
                    case '|': {
                        type = 7;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (name.equals("eq")) {
                    type = 11;
                    break;
                }
                if (name.equals("ne")) {
                    type = 12;
                    break;
                }
                if (name.equals("==")) {
                    type = 11;
                    break;
                }
                if (name.equals("!=")) {
                    type = 12;
                    break;
                }
                if (name.equals("lt")) {
                    type = 13;
                    break;
                }
                if (name.equals("gt")) {
                    type = 15;
                    break;
                }
                if (name.equals("le")) {
                    type = 14;
                    break;
                }
                if (name.equals("ge")) {
                    type = 16;
                    break;
                }
                if (name.equals("<=")) {
                    type = 14;
                    break;
                }
                if (name.equals(">=")) {
                    type = 16;
                    break;
                }
                if (name.equals("<<")) {
                    type = 8;
                    break;
                }
                if (!name.equals(">>")) break;
                type = 9;
                break;
            }
            case 3: {
                if (name.equals("eqs")) {
                    type = 21;
                    break;
                }
                if (name.equals("nes")) {
                    type = 22;
                    break;
                }
                if (name.equals("iof")) {
                    type = 20;
                    break;
                }
                if (name.equals("mul")) {
                    type = 2;
                    break;
                }
                if (name.equals("add")) {
                    type = 0;
                    break;
                }
                if (name.equals("sub")) {
                    type = 1;
                    break;
                }
                if (name.equals("div")) {
                    type = 3;
                    break;
                }
                if (name.equals("mod")) {
                    type = 4;
                    break;
                }
                if (name.equals("xor")) {
                    type = 6;
                    break;
                }
                if (name.equals("bor")) {
                    type = 7;
                    break;
                }
                if (name.equals("shl")) {
                    type = 8;
                    break;
                }
                if (name.equals("shr")) {
                    type = 9;
                    break;
                }
                if (!name.equals(">>>")) break;
                type = 10;
                break;
            }
            case 4: {
                if (name.equals("ushr")) {
                    type = 10;
                    break;
                }
                if (!name.equals("band")) break;
                type = 5;
            }
        }
        return type;
    }

    static Object evaluateExpressionGroup(OgdlEvent ev, char close) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Object output = null;
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ptn.length()) {
                OgdlSyntax.siftSpace(ev);
                output = OgdlRuntime.evaluate(ev);
                OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                off.increment();
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        off.increment();
        return output;
    }

    private static List getArguments(OgdlEvent ev, char close) {
        return (List)OgdlParser.evaluateCloseCollection(ev.get('\u0000', close, new LinkedList()));
    }

    private static Number toNumber(Object o) {
        return o instanceof Character ? (Number)Boxing.box((int)((Character)o).charValue()) : (Number)((Number)o);
    }

    private static BigInteger toBigInteger(Number n) {
        return n instanceof BigInteger ? (BigInteger)n : new BigInteger(String.valueOf(n));
    }

    private static BigDecimal toBigDecimal(Number n) {
        return n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : new BigDecimal(String.valueOf(n)));
    }

    private static boolean isStringOperand(Object f, Object t) {
        return f instanceof String || t instanceof String;
    }

    private static boolean isBooleanOperand(Object f, Object t) {
        return f instanceof Boolean && t instanceof Boolean;
    }

    private static boolean isComparableOperand(Object f, Object t) {
        return f instanceof Comparable && t instanceof Comparable;
    }

    private static boolean isNumberOperand(Object f, Object t) {
        return !(!(f instanceof Number) && !(f instanceof Character) || !(t instanceof Number) && !(t instanceof Character));
    }

    private static boolean isIntegerOperand(Number f, Number t) {
        return OgdlOperatorParser.isIntegerOperand(f) && OgdlOperatorParser.isIntegerOperand(t);
    }

    private static boolean isIntegerOperand(Number n) {
        return n instanceof Integer || n instanceof Short || n instanceof Byte;
    }
}

