/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shohaku.ogdl.BeanIntrospectHelper;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.HEval;
import shohaku.ogdl.HLog;
import shohaku.ogdl.HSet;
import shohaku.ogdl.OgdlCollectionParser;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlParser;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlIntrospectParser {
    OgdlIntrospectParser() {
    }

    static Object evaluateObjectNavigate(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Object target = ev.target;
        try {
            Object o = target;
            while (off.get() + 1 < ptn.length()) {
                char open = ptn.charAt(off.get());
                switch (open) {
                    case '[': {
                        Object key = OgdlIntrospectParser.readIndexingKeys(ev, ptn, off);
                        o = OgdlIntrospectParser.readIndexingValue(ev, key, o);
                        break;
                    }
                    case '.': {
                        off.increment();
                        String memberName = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
                        Class<?> clazz = o.getClass();
                        if (OgdlSyntax.isCharAt(ptn, off.get(), '(')) {
                            o = OgdlIntrospectParser.invokeMethod(ev, memberName, o, clazz);
                            break;
                        }
                        if (OgdlSyntax.isCharAt(ptn, off.get(), '[')) {
                            o = OgdlIntrospectParser.readIndexPropertyOrFieldOrProperty(ev, memberName, o, clazz);
                            break;
                        }
                        o = OgdlIntrospectParser.readFieldOrProperty(ev, memberName, o, clazz);
                        break;
                    }
                    case '#': {
                        off.increment();
                        String staticMemberName = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
                        if (OgdlSyntax.isCharAt(ptn, off.get(), '(')) {
                            o = OgdlIntrospectParser.invokeStaticMethod(ev, staticMemberName, o);
                            break;
                        }
                        o = OgdlIntrospectParser.readStaticFieldValue(ev, staticMemberName, o);
                        break;
                    }
                    default: {
                        return o;
                    }
                }
            }
            return o;
        }
        catch (IndexOutOfBoundsException e) {
            throw new OgdlSyntaxException(ev, "syntax err.", e);
        }
        catch (NumberFormatException e) {
            throw new OgdlSyntaxException(ev, "syntax err.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object evaluateNewInstance(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Class clazz = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        Object obj = null;
        char offLiteral = ptn.charAt(off.get());
        if (offLiteral == '#') {
            off.increment();
            String memberName = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
            if (!OgdlSyntax.isCharAt(ptn, off.get(), '(')) throw new OgdlSyntaxException(ev, "syntax err.");
            Object[] args = OgdlIntrospectParser.evaluateEncloseArguments(ev.get('(', ')'));
            try {
                obj = BeanIntrospectHelper.invokeMethod(clazz, null, memberName, args);
            }
            catch (OgdlSyntaxException e) {
                throw e.throwFor(ev);
            }
            int next_off = OgdlSyntax.siftSpace(ev);
            if (next_off >= ptn.length()) return obj;
            if (!OgdlSyntax.isCharAt(ptn, next_off, '{')) return obj;
            off.set(next_off);
            OgdlIntrospectParser.writeInitProperties(ev.get('{', '}'), obj);
            return obj;
        }
        if (offLiteral == '(') {
            Object[] args = OgdlIntrospectParser.evaluateEncloseArguments(ev.get('(', ')'));
            try {
                obj = BeanIntrospectHelper.newInstance(clazz, args);
            }
            catch (OgdlSyntaxException e) {
                throw e.throwFor(ev);
            }
            int next_off = OgdlSyntax.siftSpace(ev);
            if (!OgdlSyntax.isCharAt(ptn, next_off, '{')) return obj;
            off.set(next_off);
            OgdlIntrospectParser.writeInitProperties(ev.get('{', '}'), obj);
            return obj;
        }
        if (offLiteral == '[') {
            Integer[] dimensions = OgdlIntrospectParser.evaluateDimensionArraySizes(ev);
            try {
                return Array.newInstance(clazz, Boxing.unbox(dimensions));
            }
            catch (IllegalArgumentException e) {
                throw new OgdlSyntaxException(ev, "arrays newInstance err.", e);
            }
            catch (NegativeArraySizeException e) {
                throw new OgdlSyntaxException(ev, "arrays newInstance err.", e);
            }
        }
        if (!clazz.isArray()) {
            throw new OgdlSyntaxException(ev, "no array type. " + clazz);
        }
        int next_off = OgdlSyntax.siftSpace(ev);
        if (!OgdlSyntax.isCharAt(ptn, next_off, '{')) throw new OgdlSyntaxException(ev, "syntax err.");
        off.set(next_off);
        List list = (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('{', '}', new LinkedList()));
        try {
            return HSet.toArray(list, clazz.getComponentType());
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(ev, "array item type mismatch.", e);
        }
    }

    static Object evaluateConstructor(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        Class[] argsType = OgdlIntrospectParser.evaluateEncloseTypeArray(ev.get('(', ')'));
        try {
            return BeanIntrospectHelper.getConstructor(type, argsType);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    static Object evaluateMethod(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        if (!OgdlSyntax.isCharAt(ev, '#')) {
            throw new OgdlSyntaxException(ev, "method separator err. ");
        }
        ev.off.increment();
        String methodName = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
        Class[] argsType = OgdlIntrospectParser.evaluateEncloseTypeArray(ev.get('(', ')'));
        try {
            return BeanIntrospectHelper.getMethod(type, methodName, argsType);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    static Object evaluateField(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        if (!OgdlSyntax.isCharAt(ev, '#')) {
            throw new OgdlSyntaxException(ev, "field separator err. ");
        }
        ev.off.increment();
        String fieldName = OgdlSyntax.cutMemberName(ev.ptn, ev.off);
        try {
            return BeanIntrospectHelper.getField(type, fieldName);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Class[] evaluateEncloseTypeArray(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char open = ev.open;
        char close = ev.close;
        if (!OgdlSyntax.isCharAt(ptn, off.get(), open)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        ArrayList<Class> list = new ArrayList<Class>();
        OgdlSyntax.siftSpace(ev);
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ptn.length()) {
                list.add(OgdlPrimitiveParser.evaluateClassByExtendName(ev));
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not comma.");
                }
                off.increment();
                OgdlSyntax.siftSpace(ev);
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        Class[] types = list.toArray(new Class[0]);
        off.increment();
        return types;
    }

    private static Integer[] evaluateDimensionArraySizes(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        LinkedList<Integer> output = new LinkedList<Integer>();
        while (OgdlSyntax.isCharAt(ptn, off.get(), '[')) {
            off.increment();
            OgdlSyntax.siftSpace(ev);
            output.add(OgdlPrimitiveParser.evaluateInteger(ev));
            OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, ']')) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
            off.increment();
        }
        return output.toArray(new Integer[output.size()]);
    }

    private static Object evaluateSkipSpace(OgdlEvent ev) {
        OgdlSyntax.siftSpace(ev);
        Object o = OgdlRuntime.evaluate(ev);
        OgdlSyntax.siftSpace(ev);
        return o;
    }

    private static Object readFieldOrProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            PropertyDescriptor pd = BeanIntrospectHelper.getPropertyDescriptor(clazz, memberName);
            Object r = null;
            r = pd == null ? (OgdlSyntax.isArraylength(clazz, memberName) ? Boxing.box(Array.getLength(o)) : BeanIntrospectHelper.getFieldValue(clazz, o, memberName)) : BeanIntrospectHelper.getProperty(o, pd.getReadMethod());
            return r;
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object readStaticFieldValue(OgdlEvent ev, String memberName, Object o) {
        try {
            if (o instanceof Class) {
                return BeanIntrospectHelper.getFieldValue((Class)o, null, memberName);
            }
            throw new OgdlSyntaxException(ev, "is not Class class.");
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object readIndexedValue(OgdlEvent ev, String ptn, OgdlParseIndex off) {
        off.increment();
        Object inx = OgdlIntrospectParser.evaluateSkipSpace(ev);
        if (!OgdlSyntax.isCharAt(ptn, off.get(), ']')) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        if (!(inx instanceof Integer)) {
            throw new OgdlSyntaxException(ev, HLog.clazz("not indexing type. ", inx));
        }
        off.increment();
        return inx;
    }

    private static Object readIndexingKeys(OgdlEvent ev, String ptn, OgdlParseIndex off) {
        off.increment();
        Object key = OgdlIntrospectParser.evaluateSkipSpace(ev);
        if (!OgdlSyntax.isCharAt(ptn, off.get(), ']')) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        return key;
    }

    private static int toKeyAsIndex(OgdlEvent ev, Object key) {
        if (!(key instanceof Integer)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        return (Integer)key;
    }

    private static Object readIndexingValue(OgdlEvent ev, Object key, Object o) {
        Object r = null;
        if (o instanceof Map) {
            r = ((Map)o).get(key);
        } else if (o instanceof List) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = ((List)o).get(index);
        } else if (HEval.isArray(o)) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = Array.get(o, index);
        } else if (o instanceof CharSequence) {
            int index = OgdlIntrospectParser.toKeyAsIndex(ev, key);
            r = Boxing.box(((CharSequence)o).charAt(index));
        } else {
            throw new OgdlSyntaxException(ev, HLog.clazz("not indexing type. ", o));
        }
        return r;
    }

    private static Object readIndexPropertyOrFieldOrProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            String ptn = ev.ptn;
            OgdlParseIndex off = ev.off;
            IndexedPropertyDescriptor ipd = BeanIntrospectHelper.getIndexedPropertyDescriptor(clazz, memberName);
            Object r = null;
            if (ipd != null) {
                Object inx = OgdlIntrospectParser.readIndexedValue(ev, ptn, off);
                r = BeanIntrospectHelper.getIndexedProperty(o, ipd.getIndexedReadMethod(), (Integer)inx);
            } else {
                r = OgdlIntrospectParser.readFieldOrProperty(ev, memberName, o, clazz);
            }
            return r;
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object invokeMethod(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get('(', ')'));
            return BeanIntrospectHelper.invokeMethod(clazz, o, memberName, paramValues);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object invokeStaticMethod(OgdlEvent ev, String memberName, Object o) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get('(', ')'));
            if (o instanceof Class) {
                return BeanIntrospectHelper.invokeMethod((Class)o, null, memberName, paramValues);
            }
            throw new OgdlSyntaxException(ev, "is not Class class.");
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static Object[] evaluateEncloseArguments(OgdlEvent ev) {
        Collection val = OgdlParser.evaluateEncloseCollection(ev.get(new LinkedList()));
        return ((List)val).toArray();
    }

    private static void writeInitProperties(OgdlEvent ev, Object obj) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char open = ev.open;
        char close = ev.close;
        Class<?> clazz = obj.getClass();
        if (!OgdlSyntax.isCharAt(ptn, off.get(), open)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ptn.length()) {
                OgdlSyntax.siftSpace(ev);
                String memberName = OgdlSyntax.cutMemberName(ptn, off);
                if (OgdlSyntax.isCharAt(ptn, off.get(), '(')) {
                    OgdlIntrospectParser.invokeInitMethod(ev, memberName, obj, clazz);
                } else if (OgdlSyntax.isCharAt(ptn, off.get(), '[')) {
                    OgdlIntrospectParser.invokeInitIndexedProperty(ev, memberName, obj, clazz);
                } else {
                    OgdlIntrospectParser.invokeInitProperty(ev, memberName, obj, clazz);
                }
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not comma.");
                }
                off.increment();
                OgdlSyntax.siftSpace(ev);
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        off.increment();
        OgdlSyntax.siftSpace(ev);
    }

    private static void invokeInitIndexedProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        try {
            Object inx;
            IndexedPropertyDescriptor ipd = BeanIntrospectHelper.getIndexedPropertyDescriptor(clazz, memberName);
            if (ipd != null) {
                inx = OgdlIntrospectParser.readIndexedValue(ev, ptn, off);
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isNotMapSeparator(ptn, off)) {
                    throw new OgdlSyntaxException(ev, "is not equal.");
                }
            } else {
                throw new OgdlSyntaxException(ev, "is not Indexed property.");
            }
            off.increment();
            OgdlSyntax.siftSpace(ev);
            BeanIntrospectHelper.setIndexedProperty(o, ipd.getIndexedWriteMethod(), (Integer)inx, OgdlRuntime.evaluate(ev));
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static void invokeInitMethod(OgdlEvent ev, String memberName, Object o, Class clazz) {
        try {
            Object[] paramValues = OgdlIntrospectParser.evaluateEncloseArguments(ev.get('(', ')'));
            BeanIntrospectHelper.invokeMethod(clazz, o, memberName, paramValues);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }

    private static void invokeInitProperty(OgdlEvent ev, String memberName, Object o, Class clazz) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        try {
            PropertyDescriptor pd = BeanIntrospectHelper.getPropertyDescriptor(clazz, memberName);
            if (pd != null) {
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isNotMapSeparator(ptn, off)) {
                    throw new OgdlSyntaxException(ev, "is not equal.");
                }
            } else {
                throw new OgdlSyntaxException(ev, "is not property.");
            }
            off.increment();
            OgdlSyntax.siftSpace(ev);
            BeanIntrospectHelper.setProperty(o, pd.getWriteMethod(), OgdlRuntime.evaluate(ev));
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }
}

