/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import shohaku.ogdl.BeanIntrospectHelper;
import shohaku.ogdl.HLog;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlFunctionException;
import shohaku.ogdl.OgdlParser;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlFunctionParser {
    OgdlFunctionParser() {
    }

    static Object evaluateFunction(OgdlEvent ev) {
        String name = OgdlSyntax.cutFunctionName(ev.ptn, ev.off);
        Collection fs = ev.context.forFunctions(name);
        if (fs == null) {
            throw new OgdlSyntaxException(ev, HLog.log("no such function. ", name));
        }
        List args = (List)OgdlParser.evaluateEncloseCollection(ev.get('(', ')', new ArrayList(8)));
        Object[] values = args.toArray();
        Class[] types = BeanIntrospectHelper.toClassArray(values);
        Iterator i = fs.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!BeanIntrospectHelper.isAssignmentCompatible(m.getParameterTypes(), types)) continue;
            try {
                return m.invoke(null, values);
            }
            catch (Exception e) {
                OgdlFunctionException fe = new OgdlFunctionException(HLog.log("method invocation err. ", m, types, values), e);
                throw fe.throwFor(ev, name, args);
            }
        }
        throw new OgdlSyntaxException(ev, HLog.log("no such function. ", (Object)name, args));
    }
}

