/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import shohaku.ogdl.BeanIntrospectHelper;
import shohaku.ogdl.HLog;
import shohaku.ogdl.HSet;
import shohaku.ogdl.OgdlEvent;
import shohaku.ogdl.OgdlParseIndex;
import shohaku.ogdl.OgdlPrimitiveParser;
import shohaku.ogdl.OgdlRuntime;
import shohaku.ogdl.OgdlSyntax;
import shohaku.ogdl.OgdlSyntaxException;

class OgdlCollectionParser {
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal(BigInteger.ONE, 0);
    private static Map calendarConstants;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    OgdlCollectionParser() {
    }

    static Object evaluateCollection(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedCollection(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableCollection(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableCollection(ev);
    }

    static Object evaluateSortedMap(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedSortedMap(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableSortedMap(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSortedMap(ev);
    }

    static Object evaluateMap(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedMap(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableMap(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedMap(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableMap(ev);
    }

    static Object evaluateSortedSet(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedSortedSet(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableSortedSet(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSortedSet(ev);
    }

    static Object evaluateSet(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedSet(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableSet(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedSet(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableSet(ev);
    }

    static Object evaluateList(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        String ptn = ev.ptn;
        int begin = ev.off.get();
        if (OgdlCollectionParser.isSynchronizedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateSynchronizedList(ev);
        }
        if (OgdlCollectionParser.isUnmodifiableView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUnmodifiableList(ev);
        }
        if (OgdlCollectionParser.isUndecoratedView(off, ptn, begin)) {
            return OgdlCollectionParser.evaluateUndecoratedList(ev);
        }
        return OgdlCollectionParser.evaluateUnmodifiableList(ev);
    }

    private static boolean isSynchronizedView(OgdlParseIndex off, String ptn, int begin) {
        if (ptn.startsWith("syn:", begin)) {
            off.add(4);
            return true;
        }
        return false;
    }

    private static boolean isUnmodifiableView(OgdlParseIndex off, String ptn, int begin) {
        if (ptn.startsWith("unm:", begin)) {
            off.add(4);
            return true;
        }
        return false;
    }

    private static boolean isUndecoratedView(OgdlParseIndex off, String ptn, int begin) {
        if (ptn.startsWith("und:", begin)) {
            off.add(4);
            return true;
        }
        return false;
    }

    static Collection evaluateEncloseCollection(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char open = ev.open;
        if (!OgdlSyntax.isCharAt(ptn, off.get(), open)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        return OgdlCollectionParser.evaluateCloseCollection(ev);
    }

    static Collection evaluateCloseCollection(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char close = ev.close;
        Collection output = (Collection)ev.target;
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ptn.length()) {
                OgdlSyntax.siftSpace(ev);
                output.add(OgdlRuntime.evaluate(ev));
                OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                off.increment();
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        off.increment();
        return output;
    }

    static Map evaluateEncloseMap(OgdlEvent ev) {
        OgdlParseIndex off = ev.off;
        char open = ev.open;
        if (!OgdlSyntax.isCharAt(ev.ptn, off.get(), open)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        return OgdlCollectionParser.evaluateCloseMap(ev);
    }

    static Map evaluateCloseMap(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char close = ev.close;
        Map output = (Map)ev.target;
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ev.len) {
                OgdlSyntax.siftSpace(ev);
                Object rKey = OgdlRuntime.evaluate(ev);
                OgdlSyntax.siftSpace(ev);
                OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
                if (OgdlSyntax.isNotMapSeparator(ptn, off)) {
                    throw new OgdlSyntaxException(ev, "syntax err.");
                }
                off.increment();
                OgdlSyntax.siftSpace(ev);
                Object val = OgdlRuntime.evaluate(ev);
                OgdlSyntax.siftSpace(ev);
                output.put(rKey, val);
                if (OgdlSyntax.isIndex((CharSequence)ptn, off) && OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                off.increment();
                OgdlSyntax.siftSpace(ev);
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        off.increment();
        return output;
    }

    static Collection evaluateEncloseProgressionCollection(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char open = ev.open;
        if (!OgdlSyntax.isCharAt(ptn, off.get(), open)) {
            throw new OgdlSyntaxException(ev, "syntax err.");
        }
        off.increment();
        return OgdlCollectionParser.evaluateCloseProgressionCollection(ev);
    }

    static Collection evaluateCloseProgressionCollection(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        char close = ev.close;
        Collection output = (Collection)ev.target;
        OgdlSyntax.siftSpace(ev);
        if (OgdlSyntax.isNotClose(ptn, off, close)) {
            while (off.get() < ptn.length()) {
                OgdlSyntax.siftSpace(ev);
                Object e = OgdlRuntime.evaluate(ev);
                OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
                if (OgdlSyntax.isClose(ptn, off, close)) {
                    output.add(e);
                    break;
                }
                if (OgdlSyntax.isCharAt(ptn, off.get(), ':')) {
                    off.increment();
                    Object to = OgdlRuntime.evaluate(ev);
                    OgdlCollectionParser.addListProgressionValue(ev, output, e, to);
                } else {
                    output.add(e);
                }
                OgdlSyntax.validIndex(ev, (CharSequence)ptn, off);
                OgdlSyntax.siftSpace(ev);
                if (OgdlSyntax.isClose(ptn, off, close)) break;
                if (OgdlSyntax.isNotSeparator(ptn, off.get())) {
                    throw new OgdlSyntaxException(ev, "is not separator.");
                }
                off.increment();
            }
            OgdlSyntax.siftSpace(ev);
            if (OgdlSyntax.isNotClose(ptn, off, close)) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
        }
        off.increment();
        return output;
    }

    private static void addListProgressionValue(OgdlEvent ev, Collection output, Object from, Object to) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        String difference = null;
        OgdlSyntax.siftSpace(ev);
        if (OgdlSyntax.isCharAt(ptn, off.get(), '(')) {
            off.increment();
            OgdlSyntax.siftSpace(ev);
            difference = OgdlSyntax.cutDifferenceString(ptn, off);
            OgdlSyntax.siftSpace(ev);
            if (!OgdlSyntax.isCharAt(ptn, off.get(), ')')) {
                throw new OgdlSyntaxException(ev, "syntax err.");
            }
            off.increment();
            OgdlCollectionParser.addNumberDomain(ev, output, from, to, difference);
        } else {
            OgdlCollectionParser.addNumberDomain(ev, output, from, to);
        }
    }

    static Object evaluateDefaultMap(OgdlEvent ev) {
        LinkedHashMap output = new LinkedHashMap();
        return Collections.unmodifiableMap(OgdlCollectionParser.evaluateEncloseMap(ev.get('{', '}', output)));
    }

    static Object evaluateDefaultList(OgdlEvent ev) {
        ArrayList output = new ArrayList();
        return Collections.unmodifiableList((List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('[', ']', output)));
    }

    static Object evaluateDefaultSet(OgdlEvent ev) {
        LinkedHashSet output = new LinkedHashSet();
        return Collections.unmodifiableSet((Set)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('<', '>', output)));
    }

    static Object evaluateArray(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Class clazz = null;
        if (OgdlSyntax.isBeginMember(ptn, off.get())) {
            clazz = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        } else {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            clazz = clazz2;
        }
        OgdlSyntax.siftSpace(ev);
        Object output = null;
        List list = (List)OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('{', '}', new LinkedList()));
        try {
            output = HSet.toArray(list, clazz);
        }
        catch (IllegalArgumentException e) {
            throw new OgdlSyntaxException(ev, "array item type mismatch.", e);
        }
        return output;
    }

    private static Object evaluateUndecoratedList(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        List output = null;
        if (OgdlSyntax.isBeginMember(ptn, off.get())) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (List)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not list type. " + val.getClass(), e);
            }
        } else {
            output = new ArrayList();
        }
        OgdlSyntax.siftSpace(ev);
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('{', '}', output));
    }

    private static Object evaluateSynchronizedList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedList(ev);
        return Collections.synchronizedList((List)val);
    }

    private static Object evaluateUnmodifiableList(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedList(ev);
        return Collections.unmodifiableList((List)val);
    }

    private static Object evaluateUndecoratedSet(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Set output = null;
        if (OgdlSyntax.isBeginMember(ptn, off.get())) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (Set)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not set type. " + val.getClass(), e);
            }
        } else {
            output = new LinkedHashSet();
        }
        OgdlSyntax.siftSpace(ev);
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('{', '}', output));
    }

    private static Object evaluateSynchronizedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        Set set = Collections.synchronizedSet((Set)val);
        return set;
    }

    private static Object evaluateUnmodifiableSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        Set set = Collections.unmodifiableSet((Set)val);
        return set;
    }

    private static Object evaluateUndecoratedSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSet(ev);
        try {
            SortedSet sortedSet = Collections.synchronizedSortedSet((SortedSet)val);
            return sortedSet;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not SortedSet type. " + val.getClass(), e);
        }
    }

    private static Object evaluateSynchronizedSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        return Collections.synchronizedSortedSet((SortedSet)val);
    }

    private static Object evaluateUnmodifiableSortedSet(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedSet(ev);
        return Collections.unmodifiableSortedSet((SortedSet)val);
    }

    private static Map evaluateUndecoratedMap(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Map output = null;
        if (OgdlSyntax.isBeginMember(ptn, off.get())) {
            Object val = OgdlCollectionParser.newCollectionInstance(ev);
            try {
                output = (Map)val;
            }
            catch (ClassCastException e) {
                throw new OgdlSyntaxException(ev, "not map type. " + val.getClass(), e);
            }
        } else {
            output = new LinkedHashMap();
        }
        OgdlSyntax.siftSpace(ev);
        return OgdlCollectionParser.evaluateEncloseMap(ev.get('{', '}', output));
    }

    private static Object evaluateSynchronizedMap(OgdlEvent ev) {
        return Collections.synchronizedMap(OgdlCollectionParser.evaluateUndecoratedMap(ev));
    }

    private static Object evaluateUnmodifiableMap(OgdlEvent ev) {
        return Collections.unmodifiableMap(OgdlCollectionParser.evaluateUndecoratedMap(ev));
    }

    private static Object evaluateUndecoratedSortedMap(OgdlEvent ev) {
        Map val = OgdlCollectionParser.evaluateUndecoratedMap(ev);
        try {
            SortedMap sortedMap = Collections.synchronizedSortedMap((SortedMap)val);
            return sortedMap;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not SortedMap type. " + val.getClass(), e);
        }
    }

    private static Object evaluateSynchronizedSortedMap(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        return Collections.synchronizedSortedMap((SortedMap)val);
    }

    private static Object evaluateUnmodifiableSortedMap(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedSortedMap(ev);
        SortedMap sortedMap = Collections.unmodifiableSortedMap((SortedMap)val);
        return sortedMap;
    }

    private static Object evaluateUndecoratedCollection(OgdlEvent ev) {
        String ptn = ev.ptn;
        OgdlParseIndex off = ev.off;
        Collection output = null;
        if (!OgdlSyntax.isBeginMember(ptn, off.get())) {
            throw new OgdlSyntaxException(ev, "collection class is empty." + ptn);
        }
        Object val = OgdlCollectionParser.newCollectionInstance(ev);
        try {
            output = (Collection)val;
        }
        catch (ClassCastException e) {
            throw new OgdlSyntaxException(ev, "not collection type. " + val.getClass(), e);
        }
        OgdlSyntax.siftSpace(ev);
        return OgdlCollectionParser.evaluateEncloseProgressionCollection(ev.get('{', '}', output));
    }

    private static Object evaluateSynchronizedCollection(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        Collection coll = Collections.synchronizedCollection((Collection)val);
        return coll;
    }

    private static Object evaluateUnmodifiableCollection(OgdlEvent ev) {
        Object val = OgdlCollectionParser.evaluateUndecoratedCollection(ev);
        Collection coll = Collections.unmodifiableCollection((Collection)val);
        return coll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addNumberDomain(OgdlEvent ev, Collection coll, Object from, Object to) {
        if (from instanceof Number && to instanceof Number) {
            if (from instanceof Byte && to instanceof Byte) {
                HSet.arithmeticProgression(coll, (Byte)from, (Byte)to, (byte)1);
                return;
            } else if (from instanceof Short && to instanceof Short) {
                HSet.arithmeticProgression(coll, (Short)from, (Short)to, (short)1);
                return;
            } else if (from instanceof Integer && to instanceof Integer) {
                HSet.arithmeticProgression(coll, (Integer)from, (Integer)to, 1);
                return;
            } else if (from instanceof Long && to instanceof Long) {
                HSet.arithmeticProgression(coll, (Long)from, (Long)to, 1L);
                return;
            } else if (from instanceof Float && to instanceof Float) {
                HSet.arithmeticProgression(coll, (Float)from, (Float)to, 1);
                return;
            } else if (from instanceof Double && to instanceof Double) {
                HSet.arithmeticProgression(coll, (Double)from, (Double)to, 1L);
                return;
            } else if (from instanceof BigInteger && to instanceof BigInteger) {
                HSet.arithmeticProgression(coll, (BigInteger)from, (BigInteger)to, BigInteger.ONE);
                return;
            } else {
                if (!(from instanceof BigDecimal) || !(to instanceof BigDecimal)) throw new OgdlSyntaxException(ev, "no domain type. ");
                HSet.arithmeticProgression(coll, (BigDecimal)from, (BigDecimal)to, BIGDECIMAL_ONE);
            }
            return;
        } else if (from instanceof Character && to instanceof Character) {
            HSet.arithmeticProgression(coll, (Character)from, (Character)to, 1);
            return;
        } else {
            if (!(from instanceof Date) || !(to instanceof Date)) throw new OgdlSyntaxException(ev, "no domain type. ");
            HSet.dateTimeDomain(coll, (Date)from, (Date)to, 5, 1);
        }
    }

    private static void addNumberDomain(OgdlEvent ev, Collection coll, Object from, Object to, String difference) {
        block13: {
            try {
                if (from instanceof Number && to instanceof Number) {
                    if (from instanceof Byte && to instanceof Byte) {
                        HSet.arithmeticProgression(coll, (Byte)from, (Byte)to, Byte.parseByte(difference));
                        break block13;
                    }
                    if (from instanceof Short && to instanceof Short) {
                        HSet.arithmeticProgression(coll, (Short)from, (Short)to, Short.parseShort(difference));
                        break block13;
                    }
                    if (from instanceof Integer && to instanceof Integer) {
                        HSet.arithmeticProgression(coll, (Integer)from, (Integer)to, Integer.parseInt(difference));
                        break block13;
                    }
                    if (from instanceof Long && to instanceof Long) {
                        HSet.arithmeticProgression(coll, (Long)from, (Long)to, Long.parseLong(difference));
                        break block13;
                    }
                    if (from instanceof Float && to instanceof Float) {
                        HSet.arithmeticProgression(coll, (Float)from, (Float)to, Integer.parseInt(difference));
                        break block13;
                    }
                    if (from instanceof Double && to instanceof Double) {
                        HSet.arithmeticProgression(coll, (Double)from, (Double)to, Long.parseLong(difference));
                        break block13;
                    }
                    if (from instanceof BigInteger && to instanceof BigInteger) {
                        HSet.arithmeticProgression(coll, (BigInteger)from, (BigInteger)to, new BigInteger(difference));
                        break block13;
                    }
                    if (from instanceof BigDecimal && to instanceof BigDecimal) {
                        HSet.arithmeticProgression(coll, (BigDecimal)from, (BigDecimal)to, new BigDecimal(difference));
                        break block13;
                    }
                    throw new OgdlSyntaxException(ev, "no domain type. ");
                }
                if (from instanceof Character && to instanceof Character) {
                    HSet.arithmeticProgression(coll, (Character)from, (Character)to, Integer.parseInt(difference));
                    break block13;
                }
                if (from instanceof Date && to instanceof Date) {
                    int[] differences = OgdlCollectionParser.toDateDifferences(ev, difference);
                    HSet.dateTimeDomain(coll, (Date)from, (Date)to, differences[0], differences[1]);
                    break block13;
                }
                throw new OgdlSyntaxException(ev, "no domain type. ");
            }
            catch (NumberFormatException e) {
                throw new OgdlSyntaxException(ev, "number syntax err.", e);
            }
        }
    }

    private static int[] toDateDifferences(OgdlEvent ev, String difference) {
        String[] splits = difference.split("\\.");
        if (splits.length != 2) {
            throw new OgdlSyntaxException(ev, HLog.log("range difference syntax err.", difference));
        }
        int[] differences = new int[]{5, 1};
        differences[1] = Integer.parseInt(splits[1]);
        Integer ofield = (Integer)OgdlCollectionParser.getCalendarConstants(ev).get(splits[0]);
        if (ofield == null) {
            throw new OgdlSyntaxException(ev, HLog.log("not is calendar field.", splits[0]));
        }
        differences[0] = ofield;
        return differences;
    }

    private static Object newCollectionInstance(OgdlEvent ev) {
        Class type = OgdlPrimitiveParser.evaluateClassByExtendName(ev);
        Object output = null;
        try {
            output = BeanIntrospectHelper.newInstance(type);
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
        return output;
    }

    private static Map getCalendarConstants(OgdlEvent ev) {
        Map consts = calendarConstants;
        try {
            Map map;
            if (consts != null) {
                map = consts;
            } else {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.util.Calendar");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                map = calendarConstants = BeanIntrospectHelper.getConstantFieldMap(clazz);
            }
            return map;
        }
        catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        }
    }
}

