/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import shohaku.ogdl.Boxing;
import shohaku.ogdl.HEval;

class HSet {
    private static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal(BigInteger.ZERO, 0);

    HSet() {
    }

    static Object toArray(Collection coll, Class type) {
        Object a = Array.newInstance(type, coll.size());
        if (type.isPrimitive()) {
            int i = 0;
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                Array.set(a, i++, iter.next());
            }
        } else {
            coll.toArray((Object[])a);
        }
        return a;
    }

    static Collection dateTimeDomain(Collection coll, Date from, Date to, int field, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        Calendar fc = Calendar.getInstance();
        Calendar tc = Calendar.getInstance();
        fc.setTimeInMillis(from.getTime());
        tc.setTimeInMillis(to.getTime());
        if (HEval.isLess(from, to)) {
            long maxTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() <= maxTime) {
                coll.add(fc.getTime());
                fc.add(field, difference);
            }
        } else {
            long minTime = tc.getTimeInMillis();
            while (fc.getTimeInMillis() >= minTime) {
                coll.add(fc.getTime());
                fc.add(field, -difference);
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Character from, Character to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            char e = from.charValue();
            char maxValue = to.charValue();
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e = (char)(e + difference);
            }
        } else {
            char e = from.charValue();
            char minValue = to.charValue();
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e = (char)(e - difference);
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Byte from, Byte to, byte difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            byte e = from;
            byte maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e = (byte)(e + difference);
            }
        } else {
            byte e = from;
            byte minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e = (byte)(e - difference);
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Short from, Short to, short difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            short e = from;
            short maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e = (short)(e + difference);
            }
        } else {
            short e = from;
            short minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e = (short)(e - difference);
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Integer from, Integer to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            int e = from;
            int maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e += difference;
            }
        } else {
            int e = from;
            int minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e -= difference;
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Long from, Long to, long difference) {
        if (difference <= 0L) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            long e = from;
            long maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e += difference;
            }
        } else {
            long e = from;
            long minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e -= difference;
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Float from, Float to, int difference) {
        if (difference <= 0) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isInfiniteOrNaN(from) || HEval.isInfiniteOrNaN(to)) {
            throw new IllegalArgumentException("Infinite or NaN");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            float e = from.floatValue();
            float maxValue = to.floatValue();
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e += (float)difference;
            }
        } else {
            float e = from.floatValue();
            float minValue = to.floatValue();
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e -= (float)difference;
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, Double from, Double to, long difference) {
        if (difference <= 0L) {
            throw new IllegalArgumentException("difference <= 0");
        }
        if (HEval.isInfiniteOrNaN(from) || HEval.isInfiniteOrNaN(to)) {
            throw new IllegalArgumentException("Infinite or NaN");
        }
        if (HEval.isEqual(from, to)) {
            return coll;
        }
        if (HEval.isLess(from, to)) {
            double e = from;
            double maxValue = to;
            while (e <= maxValue) {
                coll.add(Boxing.box(e));
                e += (double)difference;
            }
        } else {
            double e = from;
            double minValue = to;
            while (e >= minValue) {
                coll.add(Boxing.box(e));
                e -= (double)difference;
            }
        }
        return coll;
    }

    /*
     * Unable to fully structure code
     */
    static Collection arithmeticProgression(Collection coll, BigInteger from, BigInteger to, BigInteger difference) {
        block4: {
            if (HEval.isLess(difference, BigInteger.ZERO)) {
                throw new IllegalArgumentException("difference <= 0");
            }
            if (HEval.isEqual(from, to)) {
                return coll;
            }
            e = from;
            if (!HEval.isLess(from, to)) ** GOTO lbl16
            while (e.compareTo(to) < 0) {
                coll.add(e);
                e = e.add(difference);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                coll.add(e);
                e = e.subtract(difference);
lbl16:
                // 2 sources

                ** while (e.compareTo((BigInteger)to) > 0)
            }
        }
        return coll;
    }

    static Collection arithmeticProgression(Collection coll, BigDecimal from, BigDecimal to, BigInteger difference) {
        return HSet.arithmeticProgression(coll, from, to, new BigDecimal(difference));
    }

    /*
     * Unable to fully structure code
     */
    static Collection arithmeticProgression(Collection coll, BigDecimal from, BigDecimal to, BigDecimal difference) {
        block4: {
            if (HEval.isLess(difference, HSet.BIGDECIMAL_ZERO)) {
                throw new IllegalArgumentException("difference <= 0");
            }
            if (HEval.isEqual(from, to)) {
                return coll;
            }
            e = from;
            if (!HEval.isLess(from, to)) ** GOTO lbl16
            while (e.compareTo(to) < 0) {
                coll.add(e);
                e = e.add(difference);
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                coll.add(e);
                e = e.subtract(difference);
lbl16:
                // 2 sources

                ** while (e.compareTo((BigDecimal)to) > 0)
            }
        }
        return coll;
    }
}

