/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ogdl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class HClass {
    static final char OBJECT_SYMBOL = 'L';
    static final Map PRIMITIVE_FOR_TYPE_MAP;
    static final Map PRIMITIVE_CLASS_NAME_MAP;

    static {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        m.put(Byte.TYPE.getName(), Byte.TYPE);
        m.put(Short.TYPE.getName(), Short.TYPE);
        m.put(Integer.TYPE.getName(), Integer.TYPE);
        m.put(Long.TYPE.getName(), Long.TYPE);
        m.put(Float.TYPE.getName(), Float.TYPE);
        m.put(Double.TYPE.getName(), Double.TYPE);
        m.put(Boolean.TYPE.getName(), Boolean.TYPE);
        m.put(Character.TYPE.getName(), Character.TYPE);
        m.put(Void.TYPE.getName(), Void.TYPE);
        PRIMITIVE_FOR_TYPE_MAP = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put(Byte.TYPE, "B");
        m.put(Short.TYPE, "S");
        m.put(Integer.TYPE, "I");
        m.put(Long.TYPE, "J");
        m.put(Float.TYPE, "F");
        m.put(Double.TYPE, "D");
        m.put(Boolean.TYPE, "Z");
        m.put(Character.TYPE, "C");
        m.put(Void.TYPE, "V");
        PRIMITIVE_CLASS_NAME_MAP = Collections.unmodifiableMap(m);
    }

    HClass() {
    }

    static String getShortClassName(Class clazz) {
        String s = clazz.getName();
        int off = s.lastIndexOf(46);
        int beginSize = -1 < off ? off + 1 : 0;
        return s.substring(beginSize, s.length());
    }

    static Class loadClass(String className, ClassLoader loader) {
        ClassLoader classLoader = loader;
        try {
            if (classLoader != null) {
                return Class.forName(className, true, loader);
            }
            return Class.forName(className);
        }
        catch (Exception exception) {
            try {
                classLoader = HClass.getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(className);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                return classLoader.loadClass(className);
            }
            catch (Exception exception3) {
                return null;
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

