/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * OGDLの実行環境を提供します。
 */
class OgdlRuntime {

    /* 単一の式を評価して返却します。 */
    static Object evaluate(OgdlEvent ev) {
        try {
            OgdlSyntax.siftSpace(ev);
            Object rvalue = OgdlParser.evaluateExpression(ev);
            if (ev.off.get() < ev.len) {
                rvalue = OgdlParser.evaluatePostfixExpression(ev, rvalue);
            }
            OgdlSyntax.siftSpace(ev);
            return rvalue;
        } catch (OgdlSyntaxException e) {
            throw e.throwFor(ev);
        } catch (RuntimeException e) {
            throw new OgdlSyntaxException(ev, "runtime err", e);
        }
    }

    /* 囲み文字を検証して、式をコンマ区切りのリストとして評価して返却します。 */
    static List evaluateList(OgdlEvent ev) {
        return OgdlParser.evaluateEncloseProgressionList(ev.get(new ArrayList()));
    }

    /* 終了文字のみ検証して、式をコンマ区切りのリストとして評価して返却します。 */
    static List evaluateCloseList(OgdlEvent ev) {
        return OgdlParser.evaluateCloseProgressionList(ev.get(new ArrayList()));
    }

    /* 囲み文字を検証して、式を '=' で対応付けられたマッピングをコンマ区切りで列挙したマップとして評価して返却します。 */
    static Map evaluateMap(OgdlEvent ev) {
        return OgdlParser.evaluateEncloseMap(ev.get(new LinkedHashMap()));
    }

    /* 終了文字のみ検証して、式を '=' で対応付けられたマッピングをコンマ区切りで列挙したマップとして評価して返却します。 */
    static Map evaluateCloseMap(OgdlEvent ev) {
        return OgdlParser.evaluateCloseMap(ev.get(new LinkedHashMap()));
    }

}
