/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

/**
 * 評価する文字列のインデックスを表現する機能を提供します。
 */
public class OgdlParseIndex {

    /** インデックス. */
    private int index;

    /**
     * Integer 型の初期値（0）で初期化します.
     */
    public OgdlParseIndex() {
        this(0);
    }

    /**
     * 指定の値で初期化します.
     * 
     * @param index
     *            初期値
     */
    public OgdlParseIndex(int index) {
        this.index = index;
    }

    /*
     * math
     */

    /**
     * 現在のインデックスを返却します。
     * 
     * @return 現在の値
     */
    public int get() {
        return this.index;
    }

    /**
     * 新たなインデックスを格納します。
     * 
     * @param index
     *            インデックス
     */
    public void set(int index) {
        this.index = index;
    }

    /**
     * 現在のインデックスに対して引数を加算します。
     * 
     * @param val
     *            加算する値
     * @return 加算後の値
     */
    public int add(int val) {
        this.index += val;
        return this.index;
    }

    /**
     * 現在のインデックスに対して引数を減算します。
     * 
     * @param val
     *            減算する値
     * @return 減算後の値
     */
    public int subtract(int val) {
        this.index -= val;
        return this.index;
    }

    /**
     * 現在のインデックスに対して値 1 を増分します。
     * 
     * @return 増分後の値
     */
    public int increment() {
        this.index++;
        return this.index;
    }

    /**
     * 現在のインデックスに対して値 1 を減分します。
     * 
     * @return 減分後の値
     */
    public int decrement() {
        this.index--;
        return this.index;
    }

    /*
     * Object
     */

    /**
     * 同値性を検証します、 OgdlParseIndex 型でありインデックスが同値の場合は true と見なします。
     * 
     * @param obj
     *            比較先
     * @return OgdlParseIndex 型でありインデックスが同値の場合は true
     */
    public boolean equals(Object obj) {
        if (obj instanceof OgdlParseIndex) {
            return index == ((OgdlParseIndex) obj).get();
        }
        return false;
    }

    /**
     * 現在のインデックスをハッシュ値として返却します。
     * 
     * @return ハッシュ値
     */
    public int hashCode() {
        return index;
    }

    /**
     * インデックスの文字列表現（String.valueOf(OgdlParseIndex.getIndex())）を返却します。
     * 
     * @return インデックスの文字列表現
     */
    public String toString() {
        return String.valueOf(index);
    }

}
