/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

/**
 * OGDLの実行イベントを提供します。 解析の実行単位で生成されます。
 */
class OgdlEvent {

    /* 式構文 */
    final String ptn;

    /* 式構文の長さ */
    final int len;

    /* 式構文の解析開始インデックス */
    final OgdlParseIndex off;

    /* クラスローダ */
    final ClassLoader loader;

    /* コンテキスト */
    final OgdlContext context;

    /* 式の処理対象の値（一時変数） */
    Object target;

    /* 式の開始文字（一時変数） */
    char open;

    /* 式の終了文字（一時変数） */
    char close;

    OgdlEvent(String pattern, OgdlParseIndex offset, ClassLoader loader, OgdlContext context) {
        this.ptn = pattern;
        this.len = pattern.length();
        this.off = offset;
        this.loader = loader;
        this.context = context;
    }

    /**
     * 指定のプロパティを更新して自身の参照を返却します。
     * 
     * @param targetValue
     *            式の処理対象の値
     * @return 自身の参照
     */
    OgdlEvent get(Object targetValue) {
        this.target = targetValue;
        return this;
    }

    /**
     * 指定のプロパティを更新して自身の参照を返却します。
     * 
     * @param openChar
     *            開始を示すリテラル文字
     * @param closeChar
     *            終了を示すリテラル文字
     * @param targetValue
     *            式の処理対象の値
     * @return 自身の参照
     */
    OgdlEvent get(char openChar, char closeChar, Object targetValue) {
        this.open = openChar;
        this.close = closeChar;
        this.target = targetValue;
        return this;
    }

    /**
     * 指定のプロパティを更新して自身の参照を返却します。
     * 
     * @param openChar
     *            開始を示すリテラル文字
     * @param closeChar
     *            終了を示すリテラル文字
     * @return 自身の参照
     */
    OgdlEvent get(char openChar, char closeChar) {
        this.open = openChar;
        this.close = closeChar;
        return this;
    }

    /**
     * "{pattern=this.pattern,offset=this.offset,target=this.target}" の表現で返却します。
     * 
     * @return このオブジェクトの文字列表現
     * @see java.lang.Object#toString()
     */
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("pattern=");
        sb.append(this.ptn);
        sb.append(",offset=");
        sb.append(this.off);
        sb.append(",target=");
        sb.append(this.target);
        sb.append("}");
        return sb.toString();
    }

}