/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ogdl;

/**
 * メッセージを生成するヘルパーメソッド群を提供します。
 */
class HLog {

    /*
     * class
     */

    /**
     * ログ出力用のオブジェクトのクラスの文字列を生成します。
     * 
     * @param o
     *            要素
     * @return ログ出力用のクラス文字列
     */
    static String clazz(Object o) {
        return (null == o) ? String.valueOf(null) : o.getClass().toString();
    }

    /**
     * ログ出力用のオブジェクトのクラスの文字列を生成します。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素
     * @return ログ出力用のクラス文字列
     */
    static String clazz(String msg, Object o) {
        return msg + clazz(o);
    }

    /*
     * log
     */

    /**
     * ログ出力用の文字列を生成します。
     * 
     * @param o
     *            要素
     * @return ログ出力用の文字列
     */
    static String log(Object o) {
        return String.valueOf(o);
    }

    /**
     * ログ出力用の文字列を生成します。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o) {
        return msg + log(o);
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, int i) {
        return msg + log(o) + ", " + i;
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, Object o1) {
        return msg + log(o) + ", " + log(o1);
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, Object o1, Object o2) {
        return msg + log(o) + ", " + log(o1) + ", " + log(o2);
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, Object o1, Object o2, Object o3) {
        return msg + log(o) + ", " + log(o1) + ", " + log(o2) + ", " + log(o3);
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @param o4
     *            要素５
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, Object o1, Object o2, Object o3, Object o4) {
        return msg + log(o) + ", " + log(o1) + ", " + log(o2) + ", " + log(o3) + ", " + log(o4);
    }

    /**
     * ログ出力用の文字列を生成します、第二引数以降はコンマで区切られます。
     * 
     * @param msg
     *            メッセージ
     * @param o
     *            要素１
     * @param o1
     *            要素２
     * @param o2
     *            要素３
     * @param o3
     *            要素４
     * @param o4
     *            要素５
     * @param o5
     *            要素６
     * @return ログ出力用の文字列
     */
    static String log(String msg, Object o, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return msg + log(o) + ", " + log(o1) + ", " + log(o2) + ", " + log(o3) + ", " + log(o4) + ", " + log(o5);
    }

}
