/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.debug;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import shohaku.core.helpers.HBeans;
import shohaku.core.helpers.HFmt;
import shohaku.core.lang.VariableInteger;

public class DumpStream
extends PrintStream {
    public static final int DEFAULT_REPETITION_LIMIT = 1024;
    private int repetitionLimit = 1024;

    public DumpStream() {
        this(System.out, false);
    }

    public DumpStream(boolean autoFlush) {
        this(System.out, autoFlush);
    }

    public DumpStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void print(Object o) {
        try {
            if (o == null) {
                this.printNull();
            } else if (o.getClass().isArray()) {
                this.printArray(o);
            } else if (o instanceof Map) {
                this.printMap((Map)o);
            } else if (o instanceof Collection) {
                this.printColl((Collection)o);
            } else if (o instanceof Date) {
                this.printDate((Date)o);
            } else if (o instanceof Pattern) {
                this.printPattern((Pattern)o);
            } else {
                super.print(o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, boolean value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, char value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, double value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, float value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, int value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, long value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object name, Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(name);
            super.print('=');
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object title, Object name, Object value1, Object value2) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            this.print(name);
            super.print('=');
            this.print(value1);
            this.print(", ");
            this.print(value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, boolean value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, char value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, double value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, float value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, int value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, long value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object name, Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, name, value);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object title, Object name, Object value1, Object value2) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title, name, value1, value2);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printnl(int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            int i = 0;
            while (i < len) {
                super.println();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printsp(int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            int i = 0;
            while (i < len) {
                super.print(' ');
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLine(int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            char[] c = new char[len];
            int i = 0;
            while (i < len) {
                c[i] = 45;
                ++i;
            }
            this.print(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printLine(len);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(Object title, int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            super.println();
            this.printLine(len);
            this.printsp(2);
            this.print(title);
            this.printsp(2);
            this.printLine(len);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLineln(int len, int beginLine, int endLine) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printnl(beginLine);
            this.printLine(len);
            this.printnl(endLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLine(int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            char[] c = new char[len];
            int i = 0;
            while (i < len) {
                c[i] = 61;
                ++i;
            }
            this.print(c);
        }
    }

    public void printDLineln(int len) {
        this.printDLineln(len, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLineln(Object title, int len) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            super.println();
            this.printDLine(len);
            this.printsp(2);
            this.print(title);
            this.printsp(2);
            this.printDLine(len);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDLineln(int len, int beginLine, int endLine) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printnl(beginLine);
            this.printDLine(len);
            this.printnl(endLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArray(Object a) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (a == null) {
                this.printNull();
            } else if (a.getClass().isArray()) {
                this.printClass(a);
                this.printDeepArrays(a);
            } else {
                super.print(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArray(Object title, Object a) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.print(title);
            super.print(" : ");
            super.println();
            this.printArray(a);
            super.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printColl(Collection c) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (c == null) {
                this.printNull();
            } else if (c.size() == 0) {
                this.printClass(c);
                this.print("[]");
            } else {
                this.printClass(c);
                super.print('[');
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                while (hasNext) {
                    Object o = i.next();
                    this.print((Object)(o == c ? "(this Collection)" : o));
                    hasNext = i.hasNext();
                    if (!hasNext) continue;
                    super.print(", ");
                }
                super.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMap(Map m) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (m == null) {
                this.printNull();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.print("{}");
            } else {
                this.printClass(m);
                super.print('{');
                boolean st = true;
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (st) {
                        st = false;
                    } else {
                        this.print(", ");
                    }
                    this.print((Object)(key == m ? "(this Map)" : key));
                    super.print('=');
                    this.print((Object)(value == m ? "(this Map)" : value));
                }
                super.println('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeColl(Collection c) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (c == null) {
                this.printNull();
            } else if (c.size() == 0) {
                this.printClass(c);
                this.print("[]");
            } else {
                this.printClass(c);
                super.print('[');
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                while (hasNext) {
                    Object o = i.next();
                    this.printClass(o);
                    this.print((Object)(o == c ? "(this Collection)" : o));
                    hasNext = i.hasNext();
                    if (!hasNext) continue;
                    super.print(", ");
                }
                super.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeMap(Map m) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (m == null) {
                this.printNull();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.print("{}");
            } else {
                this.printClass(m);
                super.print('{');
                boolean st = true;
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (st) {
                        st = false;
                    } else {
                        this.print(", ");
                    }
                    this.printClass(key);
                    this.print((Object)(key == m ? "(this Map)" : key));
                    super.print('=');
                    this.printClass(value);
                    this.print((Object)(value == m ? "(this Map)" : value));
                }
                super.println('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArrayTbl(Object a) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (a == null) {
                this.printNull();
                super.println();
            } else if (a.getClass().isArray()) {
                this.printClass(a.getClass());
                super.println('[');
                int size = Array.getLength(a);
                int i = 0;
                while (i < size) {
                    this.printsp(2);
                    this.printArray(Array.get(a, i));
                    super.println();
                    ++i;
                }
                super.println(']');
            } else {
                super.println(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printArrayTbl(Object a, int column) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (a == null) {
                this.printNull();
                super.println();
            } else if (a.getClass().isArray()) {
                int size = Array.getLength(a);
                if (size == 0 || column <= 0) {
                    this.printClass(a);
                    this.println("[]");
                } else {
                    this.printClass(a);
                    super.println('[');
                    int row = size % column == 0 ? size / column : size / column + 1;
                    int inx = 0;
                    int i = 0;
                    while (i < row && inx < size) {
                        this.printsp(2);
                        int j = 0;
                        while (j < column && inx < size) {
                            this.printArray(Array.get(a, i));
                            if (j + 1 < column && inx + 1 < size) {
                                this.print(", ");
                            }
                            ++inx;
                            ++j;
                        }
                        super.println();
                        ++i;
                    }
                    super.println(']');
                }
            } else {
                super.println(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCollTbl(Collection c) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (c == null) {
                this.printNull();
                super.println();
            } else {
                if (c.size() == 0) {
                    this.printClass(c);
                    this.println("[]");
                    return;
                }
                this.printClass(c);
                super.println('[');
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    this.printsp(2);
                    Object o = i.next();
                    this.println((Object)(o == c ? "(this Collection)" : o));
                }
                super.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCollTbl(Collection c, int column) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (c == null) {
                this.printNull();
                super.println();
            } else {
                if (c.size() == 0 || column <= 0) {
                    this.printClass(c);
                    this.println("[]");
                    return;
                }
                Iterator i = c.iterator();
                boolean hasNext = i.hasNext();
                this.printClass(c);
                super.println('[');
                while (hasNext) {
                    this.printsp(2);
                    int icolumn = 0;
                    while (hasNext && icolumn < column) {
                        Object o = i.next();
                        this.print((Object)(o == c ? "(this Collection)" : o));
                        hasNext = i.hasNext();
                        if (hasNext) {
                            super.print(", ");
                        }
                        ++icolumn;
                    }
                    super.println();
                }
                super.println(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMapTbl(Map m) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (m == null) {
                this.printNull();
                super.println();
            } else if (m.size() == 0) {
                this.printClass(m);
                this.println("{}");
            } else {
                this.printClass(m);
                super.println('{');
                Iterator i = m.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    Object value = e.getValue();
                    this.printsp(2);
                    this.print((Object)(key == m ? "(this Map)" : key));
                    super.print('=');
                    this.println((Object)(value == m ? "(this Map)" : value));
                }
                super.println('}');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBean(Object bean) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            Map props;
            try {
                props = HBeans.getProperties(bean);
            }
            catch (Exception e) {
                super.println();
                return;
            }
            this.printClass(bean);
            super.print('{');
            boolean st = true;
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ("class".equals(e.getKey())) continue;
                if (st) {
                    st = false;
                } else {
                    this.print(", ");
                }
                this.print((String)e.getKey());
                super.print('=');
                this.print(e.getValue());
            }
            super.println('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeans(Object[] beans) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printClass(beans);
            super.println();
            super.println('[');
            int i = 0;
            while (i < beans.length) {
                this.printsp(2);
                super.print('[');
                this.print(i);
                super.print(']');
                this.printBean(beans[i]);
                super.println();
                ++i;
            }
            super.println(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeanTbl(Object bean) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            Map props;
            try {
                props = HBeans.getProperties(bean);
            }
            catch (Exception e) {
                super.println();
                return;
            }
            this.print(bean.getClass().getName());
            super.println('{');
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ("class".equals(e.getKey())) continue;
                this.printsp(2);
                this.print((String)e.getKey());
                super.print('=');
                this.print(e.getValue());
                super.println();
            }
            super.println('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBeansTbl(Object[] beans) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printClass(beans);
            super.println();
            super.println('[');
            int i = 0;
            while (i < beans.length) {
                this.printsp(2);
                super.print(91 + i + 93);
                this.printBeanTbl(beans[i]);
                ++i;
            }
            super.println(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConstants(Class c) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            try {
                this.printClass(c);
                Field[] fields = c.getFields();
                super.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                        this.printsp(2);
                        this.print("public static final ");
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(null));
                    }
                    ++i;
                }
                super.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFields(Object o) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            try {
                this.printClass(o);
                Field[] fields = o.getClass().getFields();
                super.println('{');
                int i = 0;
                while (i < fields.length) {
                    int modifiers = fields[i].getModifiers();
                    if (Modifier.isPublic(modifiers)) {
                        this.printsp(2);
                        this.print("public ");
                        if (Modifier.isStatic(modifiers)) {
                            this.print("static ");
                        }
                        if (Modifier.isFinal(modifiers)) {
                            this.print("final ");
                        }
                        if (Modifier.isTransient(modifiers)) {
                            this.print("transient ");
                        }
                        if (Modifier.isVolatile(modifiers)) {
                            this.print("volatile ");
                        }
                        this.print(fields[i].getType());
                        this.print(' ');
                        this.print(fields[i].getName());
                        this.print(" = ");
                        this.println(fields[i].get(o));
                    }
                    ++i;
                }
                super.println('}');
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printClass(Object o) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (o == null) {
                return;
            }
            Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
            super.print('<');
            if (clazz.isArray()) {
                super.print(clazz.getComponentType().getName());
                super.print('[');
                super.print(Array.getLength(o));
                super.print(']');
            } else {
                super.print(clazz.getName());
            }
            super.print('>');
            if (o instanceof Collection) {
                super.print('[');
                super.print(((Collection)o).size());
                super.print(']');
            } else if (o instanceof Map) {
                super.print('[');
                super.print(((Map)o).size());
                super.print(']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printType(Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printClass(value);
            super.print(':');
            this.print(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeln(Object value) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.printClass(value);
            super.print(':');
            this.println(value);
        }
    }

    public void printNull() {
        this.print("null");
    }

    public void printDate(Date date) {
        this.print(DumpStream.formatDate(date));
    }

    public void printCurrentTime() {
        this.printDate(new Date(System.currentTimeMillis()));
    }

    public void printPattern(Pattern pattern) {
        super.print(pattern.pattern());
        super.print(',');
        super.print(pattern.flags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompBean(Object from, Object to) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            Map toProp;
            Map fromProp;
            try {
                fromProp = HBeans.getProperties(from);
                toProp = HBeans.getProperties(to);
            }
            catch (Exception e) {
                super.println();
                return;
            }
            this.printCompMap(fromProp, toProp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printCompMap(Map from, Map to) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            Iterator i = from.entrySet().iterator();
            while (i.hasNext()) {
                Object toValue;
                Map.Entry e = i.next();
                Object fromValue = e.getValue();
                if (DumpStream.deepEquals(fromValue, toValue = to.get(e.getKey()))) {
                    this.println("TRUE", e.getKey(), fromValue, toValue);
                    continue;
                }
                this.println("FALSE", e.getKey(), fromValue, toValue);
            }
        }
    }

    public int getRepetitionLimit() {
        return this.repetitionLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepetitionLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("0 > " + limit);
        }
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            this.repetitionLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printDeepArrays(Object a) {
        DumpStream dumpStream = this;
        synchronized (dumpStream) {
            if (a == null) {
                this.printNull();
                return;
            }
            Class<?> aClass = a.getClass();
            if (aClass.isArray()) {
                this.printDeepArrays(a, new VariableInteger(), 0);
            } else {
                this.print(a);
            }
        }
    }

    protected void printDeepArrays(Object a, VariableInteger count, int row) {
        if (a == null) {
            this.printNull();
            return;
        }
        super.print('[');
        int i = 0;
        while (i < Array.getLength(a)) {
            Object e;
            if (count.intValue() >= this.getRepetitionLimit()) {
                super.print("...");
                break;
            }
            count.increment();
            if (i != 0) {
                this.print(", ");
            }
            if ((e = Array.get(a, i)) == null) {
                this.printNull();
            } else {
                Class<?> eClass = e.getClass();
                if (eClass.isArray()) {
                    this.printDeepArrays(e, count, row + 1);
                } else {
                    this.print(e);
                }
            }
            ++i;
        }
        super.print(']');
    }

    protected static Object formatDate(Object date) {
        if (date instanceof Timestamp) {
            String s = DumpStream.formatDate((Date)date, "yyyy-MM-dd HH:mm:ss");
            return String.valueOf(s) + '.' + ((Timestamp)date).getNanos();
        }
        if (date instanceof Time) {
            return DumpStream.formatDate((Date)date, "HH:mm:ss");
        }
        if (date instanceof Date) {
            return DumpStream.formatDate((Date)date, "yyyy-MM-dd HH:mm:ss.SSS");
        }
        return date;
    }

    protected static String formatDate(Date date, String pattern) {
        return HFmt.formatDate(date, pattern);
    }

    protected static boolean deepEquals(Object from, Object to) {
        if (from == null || to == null) {
            return from == to;
        }
        if (from.getClass().isArray() && to.getClass().isArray()) {
            if (!from.getClass().getComponentType().equals(from.getClass().getComponentType())) {
                return false;
            }
            int size = Array.getLength(from);
            if (size != Array.getLength(to)) {
                return false;
            }
            int i = 0;
            while (i < size) {
                Object o1 = Array.get(from, i);
                Object o2 = Array.get(to, i);
                if (o1 == null || o2 == null ? o1 != o2 : !DumpStream.deepEquals(o1, o2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return from.equals(to);
    }
}

