/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import shohaku.core.helpers.HEval;
import shohaku.core.resource.ClassPathInputResource;
import shohaku.core.resource.FileSystemInputResource;
import shohaku.core.resource.InputResource;
import shohaku.core.resource.UrlInputResource;

public class InputResourceLoader {
    static final String CLASSPATH_URI_SCHEME = "classpath";
    public static final String CLASSPATH_URI_PREFIX = "classpath:";
    public static final String FILE_URI_PREFIX = "file:";
    private ClassLoader classLoader;
    private String uriPrefix;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public void setUriPrefix(String prefix) {
        this.uriPrefix = prefix;
    }

    public InputResource getInputResource(String uri) throws IOException, URISyntaxException {
        String prefix = this.getUriPrefix();
        ClassLoader loader = this.getClassLoader();
        URI resourceUri = this.getResourceUri(prefix, uri);
        String scheme = resourceUri.getScheme();
        if (HEval.isPrefix(scheme, CLASSPATH_URI_SCHEME)) {
            String classpath = resourceUri.toString().substring(CLASSPATH_URI_PREFIX.length());
            return new ClassPathInputResource(classpath, loader);
        }
        if (HEval.isPrefix(scheme, FILE_URI_PREFIX)) {
            return new FileSystemInputResource(resourceUri);
        }
        return new UrlInputResource(resourceUri.toString());
    }

    protected URI getResourceUri(String prefix, String uri) throws URISyntaxException {
        URI relativeUri = new URI(uri);
        if (relativeUri.isAbsolute() || HEval.isBlank(prefix)) {
            return relativeUri;
        }
        String relative = relativeUri.toString();
        StringBuffer sb = new StringBuffer(prefix.length() + relative.length());
        sb.append(prefix);
        if (prefix.endsWith("/")) {
            if (relative.startsWith("/")) {
                sb.append(relative.substring(1, relative.length()));
            }
        } else {
            if (!relative.startsWith("/")) {
                sb.append("/");
            }
            sb.append(relative);
        }
        return new URI(sb.toString());
    }
}

