/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import shohaku.core.helpers.HEval;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.core.resource.InputResource;

public class ClassPathInputResource
implements InputResource {
    private final String path;
    private final ClassLoader classLoader;
    private final Class clazz;

    public ClassPathInputResource(String path) {
        this(path, null, null);
    }

    public ClassPathInputResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathInputResource(String path, Class clazz) {
        this(path, null, clazz);
    }

    private ClassPathInputResource(String path, ClassLoader classLoader, Class clazz) {
        if (HEval.isBlank(path)) {
            throw new IllegalArgumentException("path is blank");
        }
        this.path = path.startsWith("/") ? path.substring(1) : path;
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.getResourceAsStream();
        }
        catch (NoSuchResourceException e) {
            FileNotFoundException fe = new FileNotFoundException("resource not exist");
            fe.initCause(e);
            throw fe;
        }
    }

    public boolean exists() {
        try {
            InputStream is = this.getResourceAsStream();
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        catch (NoSuchResourceException e) {
            return false;
        }
    }

    public long getLastModified() throws IOException {
        try {
            URLConnection con = this.getURL().openConnection();
            con.setUseCaches(false);
            return con.getLastModified();
        }
        catch (NoSuchResourceException e) {
            FileNotFoundException fe = new FileNotFoundException("resource not exist.");
            fe.initCause(e);
            throw fe;
        }
    }

    private InputStream getResourceAsStream() throws NoSuchResourceException {
        if (this.classLoader != null) {
            return FeatureFactory.getLoader().getResourceAsStream(this.path, this.classLoader);
        }
        if (this.clazz != null) {
            return FeatureFactory.getLoader().getResourceAsStream(this.path, this.clazz);
        }
        return FeatureFactory.getLoader().getResourceAsStream(this.path);
    }

    private URL getURL() throws NoSuchResourceException {
        if (this.classLoader != null) {
            return FeatureFactory.getLoader().getResource(this.path, this.classLoader);
        }
        if (this.clazz != null) {
            return FeatureFactory.getLoader().getResource(this.path, this.clazz);
        }
        return FeatureFactory.getLoader().getResource(this.path);
    }
}

