/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang.feature.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import shohaku.core.helpers.HEval;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ShohakuCoreSystem;
import shohaku.core.lang.SystemUtils;
import shohaku.core.lang.feature.ResourceLoader;
import shohaku.core.resource.InputResource;
import shohaku.core.resource.InputResourceLoader;

public class DefaultResourceLoader
implements ResourceLoader {
    static final String RESOURCE_PREFIX;
    static /* synthetic */ Class class$0;

    static {
        String syatemPrefix = SystemUtils.getSystemProperty("shohaku.resource.prefix");
        String prefix = syatemPrefix;
        if (HEval.isBlank(prefix)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("shohaku.core.lang.feature.ResourceLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            prefix = (String)ShohakuCoreSystem.getLibraryClassProperty(clazz, "resource.prefix");
        }
        if (HEval.isBlank(prefix)) {
            prefix = "classpath:";
        }
        RESOURCE_PREFIX = prefix;
    }

    public InputResourceLoader getRelativeInputResourceLoader() {
        InputResourceLoader inputResourceLoader = new InputResourceLoader();
        inputResourceLoader.setUriPrefix(RESOURCE_PREFIX);
        return inputResourceLoader;
    }

    public InputResourceLoader getInputResourceLoader() {
        InputResourceLoader inputResourceLoader = new InputResourceLoader();
        inputResourceLoader.setUriPrefix("classpath:");
        return inputResourceLoader;
    }

    public InputResource getInputResource(String url) throws IOException, URISyntaxException {
        return this.getInputResource(url, null);
    }

    public InputResource getInputResource(String url, ClassLoader loader) throws IOException, URISyntaxException {
        InputResourceLoader inputResourceLoader = this.getInputResourceLoader();
        ClassLoader l = loader != null ? loader : ClassLoader.getSystemClassLoader();
        inputResourceLoader.setClassLoader(l);
        return inputResourceLoader.getInputResource(url);
    }

    public Class getClass(String className) throws NoSuchResourceException {
        return this.getClass(className, null);
    }

    public Class getClass(String className, ClassLoader loader) throws NoSuchResourceException {
        ClassLoader classLoader = loader;
        try {
            if (classLoader != null) {
                return Class.forName(className, true, loader);
            }
            return Class.forName(className);
        }
        catch (Exception exception) {
            try {
                classLoader = this.getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(className);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                classLoader = ClassLoader.getSystemClassLoader();
                return classLoader.loadClass(className);
            }
            catch (Exception exception3) {
                throw new NoSuchResourceException("Not Find Class:" + className);
            }
        }
    }

    public URL getResource(String resource) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.feature.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getResource(resource, clazz);
    }

    public URL getResource(String resource, Class c) throws NoSuchResourceException {
        return this.getResource(resource, c.getClassLoader());
    }

    public URL getResource(String resource, ClassLoader loader) throws NoSuchResourceException {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = loader;
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
            classLoader = this.getContextClassLoader();
            if (classLoader != null && (url = classLoader.getResource(resource)) != null) {
                return url;
            }
            url = ClassLoader.getSystemResource(resource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null) {
            throw new NoSuchResourceException("Not Find Resource:" + resource);
        }
        return url;
    }

    public InputStream getResourceAsStream(String resource) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.feature.ResourceLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.getResourceAsStream(resource, clazz);
    }

    public InputStream getResourceAsStream(String resource, Class c) throws NoSuchResourceException {
        return this.getResourceAsStream(resource, c.getClassLoader());
    }

    public InputStream getResourceAsStream(String resource, ClassLoader loader) throws NoSuchResourceException {
        ClassLoader classLoader = null;
        InputStream inStream = null;
        try {
            classLoader = loader;
            if (classLoader != null && (inStream = classLoader.getResourceAsStream(resource)) != null) {
                return inStream;
            }
            classLoader = this.getContextClassLoader();
            if (classLoader != null && (inStream = classLoader.getResourceAsStream(resource)) != null) {
                return inStream;
            }
            inStream = ClassLoader.getSystemResourceAsStream(resource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inStream == null) {
            throw new NoSuchResourceException("Not Find Resource:" + resource);
        }
        return inStream;
    }

    public Object getInstance(String className) throws ObjectCreationException {
        return this.getInstance(className, null);
    }

    public Object getInstance(String className, ClassLoader loader) throws ObjectCreationException {
        try {
            return this.getClass(className, loader).newInstance();
        }
        catch (Exception e) {
            throw new ObjectCreationException("class:'" + className, e);
        }
    }

    public Object getInstance(String className, ClassLoader loader, Class[] parameterTypes, Object[] parameterValues) throws ObjectCreationException {
        try {
            Class c = this.getClass(className, loader);
            Constructor constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameterValues);
        }
        catch (Exception e) {
            throw new ObjectCreationException("class:'" + className, e);
        }
    }

    public Object getInstance(Class c) throws ObjectCreationException {
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            throw new ObjectCreationException("class:" + c, e);
        }
    }

    public Object getInstance(Class c, Class[] parameterTypes, Object[] parameterValues) throws ObjectCreationException {
        try {
            Constructor constructor = c.getConstructor(parameterTypes);
            return constructor.newInstance(parameterValues);
        }
        catch (Exception e) {
            throw new ObjectCreationException("class:" + c, e);
        }
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

