/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang.feature.impl;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import shohaku.core.lang.ShohakuCoreSystem;
import shohaku.core.lang.feature.LogFeature;

class ConsoleLogFeature
implements LogFeature {
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = false;
    protected static String dateTimeFormat = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected String logName = null;
    protected int currentLogLevel;
    protected String shortLogName = null;
    static /* synthetic */ Class class$0;

    static {
        showLogName = ConsoleLogFeature.getBooleanProperty("showlogname", showLogName);
        showShortName = ConsoleLogFeature.getBooleanProperty("showShortLogname", showShortName);
        if (showDateTime = ConsoleLogFeature.getBooleanProperty("showdatetime", showDateTime)) {
            dateTimeFormat = ConsoleLogFeature.getStringProperty("dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException e) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }

    protected static Object getProperty(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.core.lang.feature.LogFeature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ShohakuCoreSystem.getLibraryClassProperty(clazz, name);
    }

    protected static Object getProperty(String name, Object dephault) {
        Object prop = ConsoleLogFeature.getProperty(name);
        return prop == null ? dephault : prop;
    }

    protected static String getStringProperty(String name) {
        Object prop = ConsoleLogFeature.getProperty(name);
        return prop == null ? null : prop.toString();
    }

    protected static String getStringProperty(String name, String dephault) {
        Object prop = ConsoleLogFeature.getProperty(name, dephault);
        return prop == null ? null : prop.toString();
    }

    protected static boolean getBooleanProperty(String name, boolean dephault) {
        Object prop = ConsoleLogFeature.getProperty(name, dephault);
        if (prop instanceof Boolean) {
            return (Boolean)prop;
        }
        return false;
    }

    public ConsoleLogFeature(String name) {
        this.logName = name;
        this.setLevel(3);
        String lvl = ConsoleLogFeature.getStringProperty("log." + this.logName);
        int i = String.valueOf(name).lastIndexOf(".");
        String nm = name;
        while (lvl == null && i > -1) {
            nm = nm.substring(0, i);
            lvl = ConsoleLogFeature.getStringProperty("log." + nm);
            i = String.valueOf(nm).lastIndexOf(".");
        }
        if (lvl == null) {
            lvl = ConsoleLogFeature.getStringProperty("defaultlog");
        }
        if ("all".equalsIgnoreCase(lvl)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(lvl)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(lvl)) {
            this.setLevel(2);
        } else if ("info".equalsIgnoreCase(lvl)) {
            this.setLevel(3);
        } else if ("warn".equalsIgnoreCase(lvl)) {
            this.setLevel(4);
        } else if ("error".equalsIgnoreCase(lvl)) {
            this.setLevel(5);
        } else if ("fatal".equalsIgnoreCase(lvl)) {
            this.setLevel(6);
        } else if ("off".equalsIgnoreCase(lvl)) {
            this.setLevel(7);
        }
    }

    public void setLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    protected void log(int type, Object message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        if (showDateTime) {
            buf.append(dateFormatter.format(new Date()));
            buf.append(" ");
        }
        switch (type) {
            case 1: {
                buf.append("[TRACE] ");
                break;
            }
            case 2: {
                buf.append("[DEBUG] ");
                break;
            }
            case 3: {
                buf.append("[INFO] ");
                break;
            }
            case 4: {
                buf.append("[WARN] ");
                break;
            }
            case 5: {
                buf.append("[ERROR] ");
                break;
            }
            case 6: {
                buf.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = this.shortLogName.substring(this.shortLogName.lastIndexOf("/") + 1);
            }
            buf.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            buf.append(String.valueOf(this.logName)).append(" - ");
        }
        buf.append(String.valueOf(message));
        if (t != null) {
            buf.append(" <");
            buf.append(t.toString());
            buf.append(">");
            StringWriter sw = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            buf.append(sw.toString());
        }
        this.write(type, buf);
    }

    protected void write(int type, StringBuffer buffer) {
        if (type > 3) {
            System.err.println(buffer.toString());
        } else {
            System.out.println(buffer.toString());
        }
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public final void debug(Object message) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, null);
        }
    }

    public final void debug(Object message, Throwable t) {
        if (this.isLevelEnabled(2)) {
            this.log(2, message, t);
        }
    }

    public final void trace(Object message) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, null);
        }
    }

    public final void trace(Object message, Throwable t) {
        if (this.isLevelEnabled(1)) {
            this.log(1, message, t);
        }
    }

    public final void info(Object message) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, null);
        }
    }

    public final void info(Object message, Throwable t) {
        if (this.isLevelEnabled(3)) {
            this.log(3, message, t);
        }
    }

    public final void warn(Object message) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, null);
        }
    }

    public final void warn(Object message, Throwable t) {
        if (this.isLevelEnabled(4)) {
            this.log(4, message, t);
        }
    }

    public final void error(Object message) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, null);
        }
    }

    public final void error(Object message, Throwable t) {
        if (this.isLevelEnabled(5)) {
            this.log(5, message, t);
        }
    }

    public final void fatal(Object message) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, null);
        }
    }

    public final void fatal(Object message, Throwable t) {
        if (this.isLevelEnabled(6)) {
            this.log(6, message, t);
        }
    }

    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    protected static InputStream getResourceAsStream(final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResourceAsStream(name);
                }
                return ClassLoader.getSystemResourceAsStream(name);
            }
        });
    }
}

