/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.lang;

import shohaku.core.lang.Boxing;
import shohaku.core.lang.VariableNumber;

public final class VariableInteger
implements VariableNumber,
Comparable {
    private static final long serialVersionUID = 385779516456035871L;
    private int value;

    public VariableInteger() {
        this(0);
    }

    public VariableInteger(int value) {
        this.value = value;
    }

    public VariableInteger(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    public VariableInteger(Number value) {
        this.value = value.intValue();
    }

    public VariableInteger(VariableNumber value) {
        this.value = value.intValue();
    }

    public int get() {
        return this.value;
    }

    public void set(int value) {
        this.value = value;
    }

    public int add(int val) {
        this.value += val;
        return this.value;
    }

    public int subtract(int val) {
        this.value -= val;
        return this.value;
    }

    public int multiply(int val) {
        this.value *= val;
        return this.value;
    }

    public int divide(int val) {
        this.value /= val;
        return this.value;
    }

    public int increment() {
        ++this.value;
        return this.value;
    }

    public int decrement() {
        --this.value;
        return this.value;
    }

    public Number getValue() {
        return Boxing.box(this.value);
    }

    public void setValue(Number value) {
        this.set(value.intValue());
    }

    public void setValue(VariableNumber value) {
        this.set(value.intValue());
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Object obj) {
        VariableInteger anotherInteger = (VariableInteger)obj;
        int thisVal = this.value;
        int anotherVal = anotherInteger.value;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariableInteger) {
            return this.value == ((VariableInteger)obj).intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

